package com.pcloud.book.group.dao;


import com.pcloud.book.group.entity.ResourcePageNavigation;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 自有码H5页面导航(ResourcePageNavigation)表数据库访问层
 *
 * @author makejava
 * @since 2021-08-16 10:43:21
 */
public interface ResourcePageNavigationDao extends BaseDao<ResourcePageNavigation>{


    List<ResourcePageNavigation> getByPageId(Long resourcePageId);

    List<Long> getNoNavigationPages(Integer openRays);

    ResourcePageNavigation getByType(Long resourcePageId, Integer type);

    Integer getMaxSeq(Long resourcePageId);

    void deleteNavigation(Long resourcePageId, Integer type);

    ResourcePageNavigation getByName(Long resourcePageId, String navigationName);

    void updateSeq4Batch(List<ResourcePageNavigation> navigations);

    ResourcePageNavigation getNavigationByMoveType(String moveType, Long resourcePageId, Integer navigationSeq);

    void updateNavigationSeqNum(Long navigationId, Integer navigationSeq);
}