package com.pcloud.book.group.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 群二维码永久素材与公众号关系表(GroupMaterialAccount)实体类
 *
 * @author guiq
 * @since 2020-07-23
 */
@Data
public class GroupMaterialAccount implements Serializable {
    private static final long serialVersionUID = 760026119257184103L;
    /**
     * 群二维码获取永久图文素材专用公众号列表
     */
    private Long id;
    /**
     * 公众号ID
     */
    private Long accountId;
    /**
     * 该公众号下的一个永久图片素材，用于作为图文素材的封面
     */
    private String coverMediaId;
    /**
     * 群头像素材mediaId
     */
    private String headMediaId;
    /**
     * 接口调用是否达到限制 ，默认0 【0：否 1：是】
     */
    private Integer status;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 0 普通社群  1第三方社群
     */
    private Integer useType;

}