package com.pcloud.book.group.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 实体书购买(ResourcePageBookstore)实体类
 *
 * @author makejava
 * @since 2021-08-16 14:40:27
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ResourcePageBookstore extends BaseEntity {

    private static final long serialVersionUID = 537657968168101067L;
    
    @ApiModelProperty("实体书购买id")
    private Long id;
    
    @ApiModelProperty("资源页id")
    private Long resourcePageId;

    @ApiModelProperty("固定项类型；1：书店；2：优惠券；")
    private Integer fixtureType;
    
    @ApiModelProperty("服务id")
    private Long serveId;
    
    @ApiModelProperty("服务类型；APP/PRODUCT")
    private String serveType;

    @ApiModelProperty("应用作品相对链接")
    private String linkUrl;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
}
