package com.pcloud.book.group.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * (ResourcePageOuterLink)实体类
 *
 * @author wubo 
 * @since 2022-05-17 14:14:00
 */
@Data
public class ResourcePageOuterLink extends BaseEntity {

    private static final long serialVersionUID = -76290868156645860L;
    
    @ApiModelProperty("主键ID")
    private Long id;
    
    @ApiModelProperty("1哔哩哔哩 2抖音 3 小红书 4 快手")
    private Long originId;
    
    @ApiModelProperty("标题")
    private String title;
    
    @ApiModelProperty("描述")
    private String description;
    
    @ApiModelProperty("跳转链接")
    private String jumpUrl;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
    @ApiModelProperty("删除状态 ")
    private Integer isDelete;
    
    @ApiModelProperty("配置页组件id")
    private Long resourceColumnId;
    
}
