package com.pcloud.book.group.service.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.group.biz.BookGroupDataBiz;
import com.pcloud.book.group.biz.ResourcePageBiz;
import com.pcloud.book.group.dto.AddBookGroupServeDTO;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.BookGroupServiceDTO;
import com.pcloud.book.group.dto.CreateDefaultResourcePageDTO;
import com.pcloud.book.group.dto.CreateGroupDTO;
import com.pcloud.book.group.dto.MessagServeDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.book.group.enums.JoinGroupTypeEnum;
import com.pcloud.book.group.service.BookGroupDataService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import java.util.List;
import java.util.Map;

@RequestMapping("bookGroupDataService")
@RestController
public class BookGroupDataServiceImpl implements BookGroupDataService {
    @Autowired
    private BookGroupDataBiz bookGroupDataBiz;
    @Autowired
    private BookGroupBiz bookGroupBiz;
    @Autowired
    private ResourcePageBiz resourcePageBiz;

    @Override
    @RequestMapping(value = "/getBookGroupService", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<Long, List<BookGroupServiceDTO>>>> getBookGroupService(@RequestBody List<Long> bookGroupIds) {
        if(bookGroupIds==null ||bookGroupIds.size()>500){
            return null;
        }
        Map<Long, List<BookGroupServiceDTO>> map = bookGroupDataBiz.getBookGroupService(bookGroupIds);
        return ResponseHandleUtil.toResponse(map);
    }

    @Override
    @RequestMapping(value = "/createBookGroup", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<BookGroupDTO>> createBookGroup(@RequestBody CreateGroupDTO createGroupDTO) {
        Long bookId = createGroupDTO.getBookId();
        Long channelId = createGroupDTO.getChannelId();
        Long adviserId = createGroupDTO.getAdviserId();
        Integer joinGroupType = createGroupDTO.getJoinGroupType();
        Integer jumpType = createGroupDTO.getJumpType();
        if (JoinGroupTypeEnum.XIAORUI.getCode().equals(joinGroupType) && null == jumpType){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少跳转类型");
        }
        BookGroup bookGroup = bookGroupBiz.createBookGroupAfterCreateBook(bookId,channelId,adviserId,null, null,joinGroupType,jumpType,createGroupDTO.getJumpUrl());
        BookGroupDTO bookGroupDTO = new BookGroupDTO();
        BeanUtils.copyProperties(bookGroup, bookGroupDTO);
        return ResponseHandleUtil.toResponse(bookGroupDTO);
    }

    @Override
    @RequestMapping(value = "/AddBookGroupServe", method = RequestMethod.POST)
    public void AddBookGroupServe(@RequestBody List<AddBookGroupServeDTO> list,@RequestParam("partyId") Long partyId) {
        resourcePageBiz.batchAddResource(list, partyId);
    }

    @Override
    @PostMapping("batchUpdateSceneIdByBookGroup")
    public void batchUpdateSceneIdByBookGroup(@RequestBody List<AddBookGroupServeDTO> list){
        resourcePageBiz.batchUpdateSceneIdByBookGroup(list);
    }

    @Override
    @PostMapping("createDefaultResourcePage")
    public void createDefaultResourcePage(@RequestBody CreateDefaultResourcePageDTO dto) {
        if (null == dto || null == dto.getAdviserId()) {
            return;
        }
        if (null == dto.getBookGroupId() && null == dto.getSceneId()) {
            return;
        }
        //创建默认resourcePage
        resourcePageBiz.createDefaultResourcePage(dto.getBookGroupId(),dto.getAdviserId(),dto.getSceneId(),0,dto.getLandingPageType());
    }

    @GetMapping("getServeListBySceneId4QrUpdate")
    @Override
    public ResponseEntity<ResponseDto<List<MessagServeDTO>>> getServeListBySceneId4QrUpdate(@RequestParam("sceneId") Long sceneId) {
        return ResponseHandleUtil.toResponse(resourcePageBiz.getServeListBySceneId4QrUpdate(sceneId));
    }
}
