package com.pcloud.book.keywords.facade.impl;

import com.alibaba.fastjson.JSONObject;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.keywords.biz.BookKeywordBiz;
import com.pcloud.book.keywords.dto.ReplyKeywordDTO;
import com.pcloud.book.keywords.dto.ServiceResourceDTO;
import com.pcloud.book.keywords.facade.BookKeywordFacade;
import com.pcloud.book.keywords.vo.*;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.ApiOperation;

/**
 * @author lily
 * @date 2019/4/24 14:31
 */
@RestController("bookKeywordFacade")
@RequestMapping("bookKeyword")
public class BookKeywordFacadeImpl implements BookKeywordFacade {
    @Autowired
    private BookKeywordBiz bookKeywordBiz;

    @Override
    @PostMapping("insertKeyword")
    public ResponseDto<?> insertKeyword(@RequestHeader("token") String token, @RequestBody List<SetKeywordVO> setKeywordVOs) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookKeywordBiz.insertKeywords(setKeywordVOs, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateKeyword")
    public ResponseDto<?> updateKeyword(@RequestHeader("token") String token, @RequestBody UpdateKeywordVO updateKeywordVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookKeywordBiz.updateKeyword(updateKeywordVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("deleteKeyword")
    public ResponseDto<?> deleteKeyword(@RequestHeader("token") String token, @RequestBody DeleteKeywordVO deleteKeywordVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookKeywordBiz.deleteKeyword(deleteKeywordVO, partyId);
        return new ResponseDto<>();
    }


    @Override
    @GetMapping("getByBookKeyword")
    public ResponseDto<KeywordVO> getByBookKeyword(@RequestHeader("token") String token, @RequestParam("bookKeywordId") Long bookKeywordId) throws BizException, PermissionException {
        KeywordVO keywordVO = bookKeywordBiz.getByBookKeyword(bookKeywordId);
        return new ResponseDto<>(keywordVO);
    }

    @Override
    @PostMapping("setRank")
    public ResponseDto<?> setRank(@RequestHeader("token") String token, @RequestBody SetRankVO setRankVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookKeywordBiz.setRank(setRankVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("listKeywordsByBookGroup")
    public ResponseDto<PageBeanNew<ListKeywordVO>> listKeywordsByBookGroup(@RequestHeader("token") String token, @RequestBody ListKeywordParam listKeywordParam) throws BizException {
        listKeywordParam.setClassifyId(0L);
        PageBeanNew<ListKeywordVO> pageBeanNew = bookKeywordBiz.listKeywordsByClassify(listKeywordParam);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @PostMapping("listKeywordsByClassify")
    public ResponseDto<PageBeanNew<ListKeywordVO>> listKeywordsByClassify(@RequestHeader("token") String token, @RequestBody ListKeywordParam listKeywordParam) throws BizException {
        PageBeanNew<ListKeywordVO> pageBeanNew = bookKeywordBiz.listKeywordsByClassify(listKeywordParam);
        return new ResponseDto<>(pageBeanNew);
    }

    @ApiOperation("获取关键词统计列表")
    @GetMapping("getKeywordStatistics")
    @Override
    public ResponseDto<?> getKeywordStatistics(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam("bookGroupId") Long bookGroupId,
            @RequestParam(value = "weixinGroupId",required = false) String weixinGroupId
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (currentPage==null||currentPage<0||numPerPage==null||numPerPage<=0){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"分页参数错误！");
        }
        if (bookGroupId==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"社群码id不能为空！");
        }
        return new ResponseDto<>(bookKeywordBiz.getKeywordStatistics(currentPage,numPerPage,bookGroupId,weixinGroupId));
    }

    @Override
    @ApiOperation("获取关键词数量")
    @GetMapping("getKeywordCount")
    public ResponseDto<?> getKeywordCount(@RequestHeader("token") String token,@RequestParam("bookGroupId") Long bookGroupId,
                                          @RequestParam(required = false,value = "classifyId") Long classifyId) throws PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        Integer keywordCount = bookKeywordBiz.getKeywordCount(bookGroupId, classifyId);
        return new ResponseDto<>(keywordCount);
    }

    @ApiOperation("获取某个群内关键词配置的所有资源")
    @PostMapping("getAllServiceByWeixinGroup4Wechat")
    @Override
    public ResponseDto<?> getAllServiceByWeixinGroup4Wechat(@CookieValue("userInfo")String userInfo, @RequestBody QrWeixinParam qrWeixinParam)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long sceneId = Cookie.getId(userInfo, Cookie._SCENE_ID);
        Long bookGroupId = Cookie.getId(userInfo, Cookie.BOOK_GROUP_ID);
        Long classifyId = Cookie.getId(userInfo, Cookie.CLASSIFY_ID);
        Long qrcodeId = Cookie.getId(userInfo, Cookie.QRCODE_ID);
        qrWeixinParam.setBookGroupId(bookGroupId);
        qrWeixinParam.setSceneId(sceneId);
        if (qrWeixinParam.getBookGroupId() != null && !qrWeixinParam.getBookGroupId().equals(0L)) {
            List<ServiceResourceDTO> result1 = bookKeywordBiz.getServiceByWeixinGroup(qrWeixinParam, classifyId, qrcodeId);
            return new ResponseDto<>(ListUtils.isEmpty(result1) ? new ArrayList<>() : result1);
        }
        if (qrWeixinParam.getSceneId() != null && !qrWeixinParam.getSceneId().equals(0L)) {
            List<ServiceResourceDTO> result2 = bookKeywordBiz.getServiceByChannel(qrWeixinParam, wechatUserId);
            return new ResponseDto<>(ListUtils.isEmpty(result2) ? new ArrayList<>() : result2);
        }
        return new ResponseDto<>(new ArrayList<>());
    }

    @Override
    @RequestMapping(value = "getReplyKeyword", method = RequestMethod.GET)
    public ResponseDto<String> getReplyKeyword(@RequestParam String content, @RequestParam(value = "weixinGroupId", required = false) String weixinGroupId,
                                                               @RequestParam(value = "wexinGroupName", required = false) String wexinGroupName) {
        ReplyKeywordDTO replyKeywordDTO = bookKeywordBiz.getReplyKeyword(content, weixinGroupId, wexinGroupName);
        return new ResponseDto<>(JSONObject.toJSONString(replyKeywordDTO));
    }

}
