package com.pcloud.book.recommend.dao.impl;

import com.pcloud.book.recommend.entity.ResourceRecommend;
import com.pcloud.book.recommend.dao.ResourceRecommendDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 基于资源的推荐(ResourceRecommend)表数据库访问层
 *
 * @author makejava
 * @since 2021-10-29 15:22:48
 */
@Repository("resourceRecommendDaoImpl")
public class ResourceRecommendDaoImpl extends BaseDaoImpl<ResourceRecommend> implements ResourceRecommendDao {

    @Override
    public String getServeRecommend(Long adviserId,Long serveId, String serveType, Integer fromType) {
        Map<String,Object> paramMap=new HashMap<>();
        paramMap.put("serveId",serveId);
        paramMap.put("serveType",serveType);
        paramMap.put("fromType",fromType);
        paramMap.put("adviserId",adviserId);
        return super.getSessionTemplate().selectOne(getStatement("getServeRecommend"),paramMap);
    }
}