package com.pcloud.book.rightsSetting.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author lily
 * @date 2018/10/13 21:40
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@ApiModel
public class QrcodeMessage4WechatVO implements Serializable {

    private static final long serialVersionUID = -4087382700500198821L;

    private Long bookId;

    private String bookName;

    private String bookCoverImg;

    private String agentName;

    private String author;

    private Object readerNum;

    private Object readerInfo;

    private Integer serverNum;

    private Long templetId;

    private String templetName;

    private Boolean isOpenAuth;
    
    private BigDecimal originalCost;

    private List<WechatMessageVO> messages;

    @ApiModelProperty("公众号ID")
    private Long officialAccountsId;

    @ApiModelProperty("宣传语")
    private String slogan;

    @ApiModelProperty("总销售价")
    private BigDecimal totalPrice;

    @ApiModelProperty("折扣")
    private Double sale;

    @ApiModelProperty("折后价")
    private BigDecimal salePrice;

    @ApiModelProperty("短名称")
    private String shortTitle;

    @ApiModelProperty("是否开启活动")
    private Integer isOpen;

    @ApiModelProperty("授权状态")
    private Boolean authStatus;



    public Long getTempletId() {
        return templetId;
    }

    public void setTempletId(Long templetId) {
        this.templetId = templetId;
    }

    public String getTempletName() {
        return templetName;
    }

    public void setTempletName(String templetName) {
        this.templetName = templetName;
    }
    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getBookCoverImg() {
        return bookCoverImg;
    }

    public void setBookCoverImg(String bookCoverImg) {
        this.bookCoverImg = bookCoverImg;
    }

    public Object getReaderNum() {
        return readerNum;
    }

    public void setReaderNum(Object readerNum) {
        this.readerNum = readerNum;
    }

    public Object getReaderInfo() {
        return readerInfo;
    }

    public void setReaderInfo(Object readerInfo) {
        this.readerInfo = readerInfo;
    }

    public Integer getServerNum() {
        return serverNum;
    }

    public void setServerNum(Integer serverNum) {
        this.serverNum = serverNum;
    }

    public List<WechatMessageVO> getMessages() {
        return messages;
    }

    public void setMessages(List<WechatMessageVO> messages) {
        this.messages = messages;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Boolean getOpenAuth() {
        return isOpenAuth;
    }

    public void setOpenAuth(Boolean openAuth) {
        isOpenAuth = openAuth;
    }

    public BigDecimal getOriginalCost() {
        return originalCost;
    }

    public void setOriginalCost(BigDecimal originalCost) {
        this.originalCost = originalCost;
    }

    public Long getOfficialAccountsId() {
        return officialAccountsId;
    }

    public void setOfficialAccountsId(Long officialAccountsId) {
        this.officialAccountsId = officialAccountsId;
    }

    public String getSlogan() {
        return slogan;
    }

    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Double getSale() {
        return sale;
    }

    public void setSale(Double sale) {
        this.sale = sale;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public String getShortTitle() {
        return shortTitle;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public Integer getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Integer isOpen) {
        this.isOpen = isOpen;
    }

    public Boolean getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Boolean authStatus) {
        this.authStatus = authStatus;
    }

    @Override
    public String toString() {
        return "QrcodeMessage4WechatVO{" +
                "bookId=" + bookId +
                ", bookName='" + bookName + '\'' +
                ", bookCoverImg='" + bookCoverImg + '\'' +
                ", agentName='" + agentName + '\'' +
                ", readerNum=" + readerNum +
                ", readerInfo=" + readerInfo +
                ", serverNum=" + serverNum +
                ", templetId=" + templetId +
                ", templetName='" + templetName + '\'' +
                ", isOpenAuth=" + isOpenAuth +
                ", originalCost=" + originalCost +
                ", messages=" + messages +
                ", officialAccountsId=" + officialAccountsId +
                ", slogan='" + slogan + '\'' +
                ", totalPrice=" + totalPrice +
                ", sale=" + sale +
                ", salePrice=" + salePrice +
                ", shortTitle='" + shortTitle + '\'' +
                ", isOpen=" + isOpen +
                ", authStatus=" + authStatus +
                '}';
    }
}
