package com.pcloud.book.util.common;

import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookFundDto;
import com.pcloud.book.elasticsearch7.domain.entity.Es7Book;
import com.pcloud.book.elasticsearch7.domain.entity.Es7BookFund;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import com.pcloud.universe.commons.paging.Pagination;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.cglib.beans.BeanCopier;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Converter {

    private Converter() {}

    private static final BeanCopier BOOK_COPIER = BeanCopier.create(Es7Book.class, BookDto.class, false);
    private static final BeanCopier FUND_COPIER = BeanCopier.create(Es7BookFund.class, BookFundDto.class, false);

    public static BookDto convert(Es7Book book) {
        if (book == null) {
            return null;
        }
        BookDto dto = new BookDto();
        BOOK_COPIER.copy(book, dto, null);

        if (CollectionUtils.isNotEmpty(book.getBookFundList())) {
            List<BookFundDto> funds = new ArrayList<>();
            book.getBookFundList().forEach((f) -> {
                BookFundDto fundDto = new BookFundDto();
                FUND_COPIER.copy(f, fundDto, null);
                funds.add(fundDto);
            });
            funds.sort(Comparator.comparing(BookFundDto::getStartTime).reversed());
            dto.setBookFunds(funds);
        }

        return dto;
    }

    public static Pagination<ESBookAndAdviser> convert(Pagination<Es7Book> data) {
        Pagination<ESBookAndAdviser> result = new Pagination<>(data.getCurrentPage(), data.getPageSize());
        result.setTotalCount(data.getTotalCount());

        List<ESBookAndAdviser> list = new ArrayList<>();
        data.getList().forEach(b -> {
            ESBookAndAdviser ba = new ESBookAndAdviser();
            ba.setFundBookValue(b.getFundBookValue());
            ba.setIsMainEditor(b.getIsMainEditor());
            ba.setCreatedDate(b.getCreatedDate());
            ba.setLastModifiedDate(b.getLastModifiedDate());
//            ba.setBookUserCount(b.getBookUserCount());
//            ba.setHasAnswer(b.getHasAnswer());
            ba.setIsApproval(BooleanUtils.toInteger(b.getIsApproval()));
            ba.setIsFundSupport(BooleanUtils.toInteger(b.getIsFundSupport()));
            ba.setJoinGroupType(b.getJoinGroupType());
            ba.setResourceCount(b.getResourceCount());
//            ba.setAreaLabelId(b.getAreaLabelId());
            ba.setBookGroupId(b.getBookGroupId());
            ba.setGraLabelId(int2Long(b.getAdviserGraLabelId()));
//            ba.setRightsSettingId(b.getRightsSettingId());
            ba.setSubLabelId(int2Long(b.getAdviserSubLabelId()));
            ba.setVerLabelId(int2Long(b.getAdviserVerLabelId()));
            ba.setVolLabelId(int2Long(b.getAdviserVolLabelId()));
            ba.setAdviserId(long2String(b.getAdviserId()));
            ba.setBookAdviserId(long2String(b.getBookAdviserId()));
            ba.setBookId(long2String(b.getBookId()));
            ba.setBookName(b.getBookName());
            ba.setChannelId(long2String(b.getAdviserChannelId()));
            ba.setIkBookName(b.getIkBookName());
            ba.setIsAdviserBook(BooleanUtils.toString(b.getIsAdviserBook(), "1", "0"));
            ba.setIsbn(b.getIsbn());
            ba.setIsBookAdviserDelete(BooleanUtils.toString(b.getIsBookAdviserDelete(), "1", "0"));
            ba.setIsBookDelete(BooleanUtils.toString(b.getIsDelete(), "1", "0"));
            ba.setLabel1(b.getLabel1());
            ba.setLabel2(b.getLabel2());
            ba.setLabel3(b.getLabel3());
            ba.setLabel4(b.getLabel4());
            ba.setSecondTempletId(long2String(b.getAdviserSecondTempletId()));
            ba.setSerialNumber(b.getSerialNumber());
            ba.setTempletId(long2String(b.getAdviserTempletId()));
            ba.setThirdTempletId(long2String(b.getAdviserThirdTempletId()));
            ba.setTypeCode(b.getTypeCode());

            list.add(ba);
        });
        result.setList(list);
        return result;
    }

    private static String long2String(Long l) {
        return l == null ? null : l.toString();
    }

    private static Long int2Long(Integer l) {
        return l == null ? null : l.longValue();
    }
}
