package com.pcloud.book.group.service;

import java.util.List;
import java.util.Map;

import com.pcloud.book.group.dto.GroupUseDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * Description 社群书内部接口
 * Created by PENG on 2019/5/14.
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookGroupServiceCloud", path = "book/v1.0/bookGroupService")
@Api(description = "社群书内部接口")
public interface BookGroupService {

    @ApiOperation("获取社群书基本信息")
    @RequestMapping(value = "getBookGroupInfo",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookGroupDTO>> getBookGroupInfo(@RequestParam("bookGroupId")Long bookGroupId) throws BizException;

    @ApiOperation("批量获取社群书基本信息")
    @RequestMapping(value = "getBookGroupInfoByIds", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, BookGroupDTO>>> getBookGroupInfoByIds(@RequestBody List<Long> bookGroupIds) throws BizException;

    @ApiOperation("获取社群书基本信息")
    @RequestMapping(value = "getBaseInfoBySceneId",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookGroupDTO>> getBaseInfoBySceneId(@RequestParam("sceneId")Long sceneId) throws BizException;

    @ApiOperation("获取暗号状态")
    @GetMapping("/getCipherState")
    ResponseEntity<ResponseDto<Integer>> getCipherState(@RequestParam("cipher")String cipher) throws BizException;

    @ApiOperation("更新暗号状态为已使用")
    @GetMapping("/updateCipherStateToUsed")
    void updateCipherStateToUsed(@RequestParam("cipher")String cipher, @RequestParam("wxId")String wxId) throws BizException;

    @ApiOperation("获取个人二维码方式群已使用和未使用数量")
    @PostMapping("/getGroupUse")
    ResponseEntity<ResponseDto<GroupUseDTO>> getGroupUse(@RequestBody List<String> altIds) throws BizException;
}
