package com.pcloud.book.adnews.facade;

import com.pcloud.book.adnews.entity.AdNewsSet;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(value = "pcloud-service-book",qualifier = "adNewsFacadeCloud",path = "adNews")
@Api(description = "推送群消息外部接口")
public interface AdNewsFacade {


    @ApiOperation("新增编辑端早晚报设置")
    @PostMapping("/createAdNewsSet")
    ResponseDto<?> createAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("编辑端早晚报设置") AdNewsSet adNewsSet
    ) throws BizException, PermissionException;

    @ApiOperation("修改编辑端早晚报设置")
    @PostMapping("/updateAdNewsSet")
    ResponseDto<?> updateAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("编辑端早晚报设置") AdNewsSet adNewsSet
    ) throws BizException, PermissionException;

    @ApiOperation("获取编辑早晚报设置")
    @GetMapping("/getAdNewsSet")
    ResponseDto<?> getAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token
    ) throws BizException, PermissionException;

    @ApiOperation("编辑添加选择的早晚报素材")
    @PostMapping("/createAdNewsChooseBatch")
    ResponseDto<?> createAdNewsChooseBatch(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("新闻id集合") List<Long> adNewsIds
    ) throws BizException, PermissionException;

    @ApiOperation("编辑移除选择的早晚报素材")
    @GetMapping("/deleteAdNewsChoose")
    ResponseDto<?> deleteAdNewsChoose(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam @ApiParam("adNewsChooseId") Long adNewsChooseId
    ) throws BizException, PermissionException;

    @ApiOperation("获取早晚报素材库")
    @GetMapping("/getAdNewsList")
    ResponseDto<?> getAdNewsList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "title",required = false) @ApiParam("标题") String title,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("获取编辑选择的早晚报素材库")
    @GetMapping("/getAdNewsChooseList")
    ResponseDto<?> getAdNewsChooseList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "title",required = false) @ApiParam("标题") String title,
            @RequestParam(value = "hasUsed",required = false) @ApiParam("标题") Boolean hasUsed,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

}
