package com.pcloud.book.adnews.facade.impl;

import com.pcloud.book.adnews.biz.AdNewsBiz;
import com.pcloud.book.adnews.entity.AdNewsSet;
import com.pcloud.book.adnews.facade.AdNewsFacade;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 15:00
 **/
@RestController("adNewsFacade")
@RequestMapping("adNews")
public class AdNewsFacadeImpl implements AdNewsFacade {


    @Autowired
    private AdNewsBiz adNewsBiz;

    @ApiOperation("新增编辑端早晚报设置")
    @PostMapping("/createAdNewsSet")
    @Override
    public ResponseDto<?> createAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("编辑端早晚报设置") AdNewsSet adNewsSet
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (adNewsSet == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数错误");
        }
        adNewsSet.setCreateUser(partyId);
        adNewsSet.setUpdateUser(partyId);
        return new ResponseDto<>(adNewsBiz.createAdNewsSet(adNewsSet));
    }

    @ApiOperation("修改编辑端早晚报设置")
    @PostMapping("/updateAdNewsSet")
    @Override
    public ResponseDto<?> updateAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("编辑端早晚报设置") AdNewsSet adNewsSet
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (adNewsSet == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数错误");
        }
        if (adNewsSet.getId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "早晚报设置id不能为空");
        }

        adNewsSet.setUpdateUser(partyId);
        adNewsBiz.updateAdNewsSet(adNewsSet);
        return new ResponseDto<>();
    }

    @ApiOperation("获取编辑早晚报设置")
    @GetMapping("/getAdNewsSet")
    @Override
    public ResponseDto<?> getAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(adNewsBiz.getAdNewsSet(partyId));
    }

    @ApiOperation("编辑添加选择的早晚报素材")
    @PostMapping("/createAdNewsChooseBatch")
    @Override
    public ResponseDto<?> createAdNewsChooseBatch(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("新闻id集合") List<Long> adNewsIds
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (ListUtils.isEmpty(adNewsIds)){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数错误");
        }
        adNewsBiz.createAdNewsChooseBatch(adNewsIds,partyId);
        return new ResponseDto<>();
    }

    @ApiOperation("编辑移除选择的早晚报素材")
    @GetMapping("/deleteAdNewsChoose")
    @Override
    public ResponseDto<?> deleteAdNewsChoose(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam @ApiParam("adNewsId") Long adNewsId
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (adNewsId == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数错误");
        }
        adNewsBiz.deleteAdNewsChoose(adNewsId, partyId);
        return new ResponseDto<>();
    }

    @ApiOperation("获取早晚报素材库")
    @GetMapping("/getAdNewsList")
    @Override
    public ResponseDto<?> getAdNewsList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "title",required = false) @ApiParam("标题") String title,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (currentPage == null || currentPage < 0) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "当前页不能为空且不能小于0！");
        }
        if (numPerPage == null || numPerPage <= 0) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "每页条数不能为空且必须大于0！");
        }
        return new ResponseDto<>(adNewsBiz.getAdNewsList(title,partyId,currentPage,numPerPage));
    }

    @ApiOperation("获取编辑选择的早晚报素材库")
    @GetMapping("/getAdNewsChooseList")
    @Override
    public ResponseDto<?> getAdNewsChooseList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "title",required = false) @ApiParam("标题") String title,
            @RequestParam(value = "hasUsed",required = false) @ApiParam("使用状态") Boolean hasUsed,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (currentPage == null || currentPage < 0) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "当前页不能为空且不能小于0！");
        }
        if (numPerPage == null || numPerPage <= 0) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "每页条数不能为空且必须大于0！");
        }
        return new ResponseDto<>(adNewsBiz.getAdNewsChooseList(partyId, title, hasUsed, currentPage, numPerPage));
    }


}
