package com.pcloud.book.advertising.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.pcloud.common.entity.BaseEntity;

/**
 * @author PENG
 */
public class AdvertisingSpace extends BaseEntity {

    private static final long serialVersionUID = -2436861846992974754L;

    /**
     * advertising_space.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_space.ad_name (广告位名称)
     */
    private String adName;

    /**
     * advertising_space.ad_position (广告位置)
     */
    private String adPosition;

    /**
     * advertising_space.ad_position_mode (广告位置方式)
     */
    private String adPositionMode;

    /**
     * advertising_space.ad_position_detail (具体广告位置)
     */
    private String adPositionDetail;

    /**
     * advertising_space.master_id (广告主ID)
     */
    private Long masterId;

    /**
     * advertising_space.ad_link (广告位链接)
     */
    private String adLink;

    /**
     * advertising_space.source_id (对方id)
     */
    private String sourceId;

    /**
     * advertising_space.ad_title (广告位标题)
     */
    private String adTitle;

    /**
     * advertising_space.ad_slogan (广告位文案)
     */
    private String adSlogan;

    /**
     * advertising_space.ad_pic (广告位图片)
     */
    private String adPic;

    /**
     * advertising_space.create_time (创建时间)
     */
    private Date createTime;

    /**
     * advertising_space.update_time (修改时间)
     */
    private Date updateTime;

    /**
     * 是否测试
     */
    private Boolean isTest;

    /**
     * advertising_space.is_open (是否打开)
     */
    private Boolean isOpen;
    /**
     *广告详情方式
     */
    private String adDetailMode;
    /**
     *广告详情封面
     */
    private String adDetailCoverPic;
    /**
     *广告详情优惠图
     */
    private String adDetailWelfarePic;
    /**
     *广告详情介绍
     */
    private String adDetailInfo;
    /**
     *广告详情文件ID
     */
    private String adDetailFileId;
    /**
     *广告详情文件转码状态
     */
    private Integer adDetailFileConvertState;
    /**
     *广告详情文件路径
     */
    private String adDetailFileUrl;
    /**
     *广告详情文件标题
     */
    private String adDetailTitle;
    /**
     *广告详情文件试播秒数
     */
    private Long adDetailFilePilotSecond;
    /**
     *广告详情文件试播路径
     */
    private String adDetailFilePilotUrl;
    /**
     *广告详情文件试播结束提示
     */
    private String adDetailFilePilotFinishTip;

    /**
     * 报名选项设置
     */
    private List<AdvertisingBmOption> advertisingBmOptionList;
    /**
     *广告报名表单是否校验手机号
     */
    private Boolean adFormMobileCheck;
    /**
     *广告报名表单备注
     */
    private String adFormRemark;
    /**
     *广告报名表单提交按钮
     */
    private String adFormButton;
    /**
     *广告报名表单跳转链接
     */
    private String adFormLink;

    /**
     * 结算方式
     */
    private String settlementMethod;

    /**
     * 每次价格
     */
    private BigDecimal priceEachTime;

    /**
     * 广告详情文件大小
     */
    private Long adDetailFileSize;
    /**
     * 广告详情文件名称
     */
    private String adDetailFileName;

    /**
     * 广告详情文件时长
     */
    private Long adDetailFileDuration;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getAdName() {
        return adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public String getAdPosition() {
        return adPosition;
    }

    public void setAdPosition(String adPosition) {
        this.adPosition = adPosition;
    }

    public String getAdPositionMode() {
        return adPositionMode;
    }

    public void setAdPositionMode(String adPositionMode) {
        this.adPositionMode = adPositionMode;
    }

    public String getAdPositionDetail() {
        return adPositionDetail;
    }

    public void setAdPositionDetail(String adPositionDetail) {
        this.adPositionDetail = adPositionDetail;
    }

    public Long getMasterId() {
        return masterId;
    }

    public void setMasterId(Long masterId) {
        this.masterId = masterId;
    }

    public String getAdLink() {
        return adLink;
    }

    public void setAdLink(String adLink) {
        this.adLink = adLink;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getAdTitle() {
        return adTitle;
    }

    public void setAdTitle(String adTitle) {
        this.adTitle = adTitle;
    }

    public String getAdSlogan() {
        return adSlogan;
    }

    public void setAdSlogan(String adSlogan) {
        this.adSlogan = adSlogan;
    }

    public String getAdPic() {
        return adPic;
    }

    public void setAdPic(String adPic) {
        this.adPic = adPic;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public String getSettlementMethod() {
        return settlementMethod;
    }

    public void setSettlementMethod(String settlementMethod) {
        this.settlementMethod = settlementMethod;
    }

    public BigDecimal getPriceEachTime() {
        return priceEachTime;
    }

    public void setPriceEachTime(BigDecimal priceEachTime) {
        this.priceEachTime = priceEachTime;
    }

    public String getAdDetailMode() {
        return adDetailMode;
    }

    public void setAdDetailMode(String adDetailMode) {
        this.adDetailMode = adDetailMode;
    }

    public String getAdDetailCoverPic() {
        return adDetailCoverPic;
    }

    public void setAdDetailCoverPic(String adDetailCoverPic) {
        this.adDetailCoverPic = adDetailCoverPic;
    }

    public String getAdDetailWelfarePic() {
        return adDetailWelfarePic;
    }

    public void setAdDetailWelfarePic(String adDetailWelfarePic) {
        this.adDetailWelfarePic = adDetailWelfarePic;
    }

    public String getAdDetailInfo() {
        return adDetailInfo;
    }

    public void setAdDetailInfo(String adDetailInfo) {
        this.adDetailInfo = adDetailInfo;
    }

    public String getAdDetailFileId() {
        return adDetailFileId;
    }

    public void setAdDetailFileId(String adDetailFileId) {
        this.adDetailFileId = adDetailFileId;
    }

    public Integer getAdDetailFileConvertState() {
        return adDetailFileConvertState;
    }

    public void setAdDetailFileConvertState(Integer adDetailFileConvertState) {
        this.adDetailFileConvertState = adDetailFileConvertState;
    }

    public String getAdDetailFileUrl() {
        return adDetailFileUrl;
    }

    public void setAdDetailFileUrl(String adDetailFileUrl) {
        this.adDetailFileUrl = adDetailFileUrl;
    }

    public String getAdDetailTitle() {
        return adDetailTitle;
    }

    public void setAdDetailTitle(String adDetailTitle) {
        this.adDetailTitle = adDetailTitle;
    }

    public Long getAdDetailFilePilotSecond() {
        return adDetailFilePilotSecond;
    }

    public void setAdDetailFilePilotSecond(Long adDetailFilePilotSecond) {
        this.adDetailFilePilotSecond = adDetailFilePilotSecond;
    }

    public String getAdDetailFilePilotUrl() {
        return adDetailFilePilotUrl;
    }

    public void setAdDetailFilePilotUrl(String adDetailFilePilotUrl) {
        this.adDetailFilePilotUrl = adDetailFilePilotUrl;
    }

    public String getAdDetailFilePilotFinishTip() {
        return adDetailFilePilotFinishTip;
    }

    public void setAdDetailFilePilotFinishTip(String adDetailFilePilotFinishTip) {
        this.adDetailFilePilotFinishTip = adDetailFilePilotFinishTip;
    }

    public Boolean getAdFormMobileCheck() {
        return adFormMobileCheck;
    }

    public void setAdFormMobileCheck(Boolean adFormMobileCheck) {
        this.adFormMobileCheck = adFormMobileCheck;
    }

    public String getAdFormRemark() {
        return adFormRemark;
    }

    public void setAdFormRemark(String adFormRemark) {
        this.adFormRemark = adFormRemark;
    }

    public String getAdFormButton() {
        return adFormButton;
    }

    public void setAdFormButton(String adFormButton) {
        this.adFormButton = adFormButton;
    }

    public String getAdFormLink() {
        return adFormLink;
    }

    public void setAdFormLink(String adFormLink) {
        this.adFormLink = adFormLink;
    }

    public Boolean getIsTest() {
        return isTest;
    }

    public void setIsTest(Boolean isTest) {
        this.isTest = isOpen;
    }

    public List<AdvertisingBmOption> getAdvertisingBmOptionList() {
        return advertisingBmOptionList;
    }

    public void setAdvertisingBmOptionList(List<AdvertisingBmOption> advertisingBmOptionList) {
        this.advertisingBmOptionList = advertisingBmOptionList;
    }

    public Long getAdDetailFileSize() {
        return adDetailFileSize;
    }

    public void setAdDetailFileSize(Long adDetailFileSize) {
        this.adDetailFileSize = adDetailFileSize;
    }

    public String getAdDetailFileName() {
        return adDetailFileName;
    }

    public void setAdDetailFileName(String adDetailFileName) {
        this.adDetailFileName = adDetailFileName;
    }

    public Long getAdDetailFileDuration() {
        return adDetailFileDuration;
    }

    public void setAdDetailFileDuration(Long adDetailFileDuration) {
        this.adDetailFileDuration = adDetailFileDuration;
    }

    @Override
    public String toString() {
        return "AdvertisingSpace{" +
                "id=" + id +
                ", adName='" + adName + '\'' +
                ", adPosition='" + adPosition + '\'' +
                ", adPositionMode='" + adPositionMode + '\'' +
                ", adPositionDetail='" + adPositionDetail + '\'' +
                ", masterId=" + masterId +
                ", adLink='" + adLink + '\'' +
                ", sourceId='" + sourceId + '\'' +
                ", adTitle='" + adTitle + '\'' +
                ", adSlogan='" + adSlogan + '\'' +
                ", adPic='" + adPic + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isTest=" + isTest +
                ", isOpen=" + isOpen +
                ", adDetailMode='" + adDetailMode + '\'' +
                ", adDetailCoverPic='" + adDetailCoverPic + '\'' +
                ", adDetailWelfarePic='" + adDetailWelfarePic + '\'' +
                ", adDetailInfo='" + adDetailInfo + '\'' +
                ", adDetailFileId='" + adDetailFileId + '\'' +
                ", adDetailFileConvertState=" + adDetailFileConvertState +
                ", adDetailFileUrl='" + adDetailFileUrl + '\'' +
                ", adDetailTitle='" + adDetailTitle + '\'' +
                ", adDetailFilePilotSecond=" + adDetailFilePilotSecond +
                ", adDetailFilePilotUrl='" + adDetailFilePilotUrl + '\'' +
                ", adDetailFilePilotFinishTip='" + adDetailFilePilotFinishTip + '\'' +
                ", advertisingBmOptionList=" + advertisingBmOptionList +
                ", adFormMobileCheck=" + adFormMobileCheck +
                ", adFormRemark='" + adFormRemark + '\'' +
                ", adFormButton='" + adFormButton + '\'' +
                ", adFormLink='" + adFormLink + '\'' +
                ", settlementMethod='" + settlementMethod + '\'' +
                ", priceEachTime=" + priceEachTime +
                ", adDetailFileSize=" + adDetailFileSize +
                ", adDetailFileName='" + adDetailFileName + '\'' +
                ", adDetailFileDuration=" + adDetailFileDuration +
                '}';
    }
}