package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.JoinGroupCipherDao;
import com.pcloud.book.group.entity.JoinGroupCipher;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/8/5 16:18
 **/
@Component("joinGroupCipherDao")
public class JoinGroupCipherDaoImpl extends BaseDaoImpl<JoinGroupCipher> implements JoinGroupCipherDao {
    @Override
    public JoinGroupCipher getByWechatUserId(Long wechatUserId,Long classifyId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("classifyId",classifyId);
        return this.getSqlSession().selectOne(this.getStatement("getByWechatUserId"), map);
    }

    @Override
    public JoinGroupCipher getByCipher(String cipher) {
        return this.getSqlSession().selectOne(this.getStatement("getByCipher"), cipher);
    }

    @Override
    public void updateCipherStateToUsed(String cipher, String wxId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cipher",cipher);
        map.put("wxId",wxId);
        this.getSqlSession().update(this.getStatement("updateCipherStateToUsed"), map);
    }
}
