package com.pcloud.common.core.biz;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.constant.FunnelFlowStruct.FlowNode;
import com.pcloud.common.core.constant.FunnelFlowStruct.TargetRoleType;
import com.pcloud.common.core.constant.FunnelFlowStruct.TargetType;
import com.pcloud.common.core.dto.FunnelFlowQueueDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述： 发送模板消息队列实现类
 * @作者： shuyh
 * @创建时间： 2018年1月9日
 * @版本：1.0
 */
@Component("funnelFlowQueueBiz")
public class FunnelFlowQueueBizImpl implements FunnelFlowQueueBiz{

	/**
	 * 
	 */
	private final static Logger logger=LoggerFactory.getLogger(FunnelFlowQueueBizImpl.class);
	
	@Autowired(required=false)
	@Qualifier("jmsFunnelFlowTemplate")
	private JmsTemplate jmsFunnelFlowTemplate;
	
	@Autowired(required=false)
	@Qualifier("funnelFlowQueue")
	private ActiveMQQueue funnelFlowQueue;

	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(FunnelFlowQueueDto funnelFlowQueueDto) throws BizException {
		MessageCreator messageCreator = new MessageCreator() {
			@Override
			public ObjectMessage createMessage(Session session) throws JMSException {
				return session.createObjectMessage(funnelFlowQueueDto);
			}
		};

		try {
			jmsFunnelFlowTemplate.send(funnelFlowQueue, messageCreator);
		} catch (Exception e) {
			logger.error("发送失败，" + e.getMessage() + "," + funnelFlowQueueDto, e);
			throw BizException.SEND_QUEUE_FAIL;
		}
		logger.info("发送成功，" + funnelFlowQueueDto);
	}
	
	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(TargetType targetType, TargetRoleType targetRoleType, FlowNode flowNode, String ip, String userAgent) throws BizException {
		FunnelFlowQueueDto funnelFlowQueueDto = new FunnelFlowQueueDto(targetType, targetRoleType, flowNode, ip, userAgent);
		sendMessageQueue(funnelFlowQueueDto);
	}

	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(TargetType targetType, Long targetId, TargetRoleType targetRoleType, Long targetRoleId, FlowNode flowNode) throws BizException {
		FunnelFlowQueueDto funnelFlowQueueDto = new FunnelFlowQueueDto(targetType, targetId, targetRoleType, targetRoleId, flowNode);
		sendMessageQueue(funnelFlowQueueDto);
	}
	
	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(TargetType targetType, Long targetId, String subtypeCode, TargetRoleType targetRoleType, Long targetRoleId, FlowNode flowNode) throws BizException {
		FunnelFlowQueueDto funnelFlowQueueDto = new FunnelFlowQueueDto(targetType, targetId, subtypeCode, targetRoleType, targetRoleId, flowNode);
		sendMessageQueue(funnelFlowQueueDto);
	}
	
}
