package com.pcloud.common.core.biz;

import com.pcloud.common.core.dto.DynamicDto;
import com.pcloud.common.exceptions.BizException;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

/**
 * @描述：
 * @作者：lucas
 * @创建时间：2017年12月14日,15:58
 * @版本：1.0
 */
@Component("merchantDynamicQueueBiz")
public class MerchantDynamicQueueBizImpl implements MerchantDynamicQueueBiz {

    private final static Logger logger= LoggerFactory.getLogger(MerchantDynamicQueueBizImpl.class);
    /**
     * 消息模板
     */
    @Autowired(required=false)
    @Qualifier("jmsDynamicTemplate")
    private JmsTemplate jmsDynamicTemplate;

    @Override
    public void send(DynamicDto dynamicDto) throws BizException {
        MessageCreator messageCreator = new MessageCreator() {
            @Override
            public ObjectMessage createMessage(Session session) throws JMSException {
                return session.createObjectMessage(dynamicDto);
            }
        };
        try {
            jmsDynamicTemplate.send(messageCreator);
        } catch (Exception e) {
            logger.error("发送失败，"+e.getMessage()+","+dynamicDto,e);
            throw BizException.SEND_QUEUE_FAIL;
        }

        logger.info("发送成功，"+dynamicDto);
    }
}
