package com.pcloud.common.core.biz;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;

import com.pcloud.common.core.dto.UserActionMessageDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述： 发送模板消息队列实现类
 * @作者： shuyh
 * @创建时间： 2017年5月23日
 * @版本：1.0
 */
@Service("userActionQueueBiz")
public class UserActionQueueBizImpl implements UserActionQueueBiz{

	/**
	 * 
	 */
	private final static Logger logger=LoggerFactory.getLogger(UserActionQueueBizImpl.class);
	
	@Autowired(required=false)
	@Qualifier("jmsUserActionTemplate")
	private JmsTemplate jmsUserActionTemplate;

	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(UserActionMessageDto userActionMessageDto) throws BizException {
		MessageCreator messageCreator = new MessageCreator() {
			@Override
			public ObjectMessage createMessage(Session session) throws JMSException {
				return session.createObjectMessage(userActionMessageDto);
			}
		};
		try {
			jmsUserActionTemplate.send(messageCreator);
		} catch (Exception e) {
			logger.error("发送失败，" + e.getMessage() + "," + userActionMessageDto, e);
			throw BizException.SEND_QUEUE_FAIL;
		}
		logger.info("发送成功，" + userActionMessageDto);
	}

}
