package com.pcloud.book.applet.service;


import com.pcloud.book.applet.dto.AppletNewsVO;
import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.dto.PcloudGroupActivityDTO;
import com.pcloud.common.dto.ResponseDto;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@FeignClient(value = "pcloud-service-book", qualifier = "appletServiceCloud", path = "book/v1.0/appletService")
@Api(description = "小程序内部接口")
public interface AppletService {


    @ApiOperation("根据资讯id查资讯")
    @GetMapping("getNewsById")
    public ResponseEntity<ResponseDto<AppletNewsVO>> getNewsById(@RequestParam("newsId") Long newsId);

    //add by pansy 2020/07/02
    @ApiOperation("根据第三方群id获取信息")
    @GetMapping("getGroupActivityById")
    public ResponseEntity<ResponseDto<PcloudGroupActivityDTO>> getGroupActivityById(@RequestParam("id") Long id);

    @ApiOperation("根据id查外部书刊")
    @GetMapping("getOuterBookById")
    public ResponseEntity<ResponseDto<AppletOuterBookDTO>> getOuterBookById(@RequestParam("outerBookId") Long outerBookId);

    @ApiOperation("给出版分配小睿基本书刊分类")
    @GetMapping("createBaseClassifysToAgent")
    void createBaseClassifysToAgent(@RequestParam("agentId") @ApiParam Long agentId);

}
