package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletOuterBooklistDao;
import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.dto.AppletOuterBooklistDTO;
import com.pcloud.book.applet.dto.OuterBooklistAddDTO;
import com.pcloud.book.applet.entity.AppletOuterBooklist;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.applet.dao.impl.AppletOuterBooklistDaoImpl
 * @Author zhuyajie
 * @Description
 * @Date 2020/8/11 14:15
 * @Version 1.0
 **/
@Component
public class AppletOuterBooklistDaoImpl extends BaseDaoImpl<AppletOuterBooklist> implements AppletOuterBooklistDao {

    @Override
    public void addOuterBooklistConfig(List<OuterBooklistAddDTO> addDTOS) {
        getSessionTemplate().insert(getStatement("addOuterBooklistConfig"), addDTOS);
    }

    @Override
    public void deleteConfigByOuterBooklistId(Long booklistId) {
        getSessionTemplate().delete(getStatement("deleteConfigByOuterBooklistId"), booklistId);
    }

    @Override
    public List<Long> getBookIdsByBooklistId(Long booklistId) {
        return getSessionTemplate().selectList(getStatement("getBookIdsByBooklistId"), booklistId);
    }

    @Override
    public Integer getBooklistCountsByBookId(Long outerBookId) {
        return getSessionTemplate().selectOne(getStatement("getBooklistCountsByBookId"), outerBookId);
    }

    @Override
    public List<String> getOuterBooklistPublish(Long agentId) {
        Map<String,Object>map = new HashMap<>();
        map.put("agentId", agentId);
        return getSessionTemplate().selectList(getStatement("getOuterBooklistPublish"), map);
    }

    @Override
    public List<AppletOuterBookDTO> getBookListByBooklistId(Long booklistId) {
        return getSessionTemplate().selectList(getStatement("getBookListByBooklistId"), booklistId);
    }

    @Override
    public Map<Long, AppletOuterBooklistDTO> getByIds(List<Long> booklistIds) {
        return getSessionTemplate().selectMap(getStatement("getByIds"), booklistIds, "id");
    }

    @Override
    public void batchDeleteOuterBookFromBooklist(List<Long> configIds) {
        getSessionTemplate().delete(getStatement("batchDeleteOuterBookFromBooklist"), configIds);
    }
}
