package com.pcloud.book.es.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * book_group_qrcode Elasticsearch 索引配置
 *
 * @author guiq
 * @version 1.0
 * @since 2020年7月10日
 */
@Data
@Document(indexName = "book", type = "book_group_qrcode")
public class ESBookGroupQrcode {
    @Field(type = FieldType.Long, index = FieldIndex.no)
    private static final long serialVersionUID = 353789664671201879L;

    @Id
    private Long id;
    /**
     * 分类标识
     */
    private Long classifyId;
    /**
     * 群名称
     */
    @Field(type = FieldType.String, index = FieldIndex.analyzed, analyzer = "ik_smart", searchAnalyzer = "ik_smart")
    private String groupName;
    /**
     * 序号
     */
    private Integer groupSeq;
    /**
     * 群人数
     */
    private Integer userNumber;
    /**
     * 微信群标识
     */
    private Long weixinQrcodeId;
    /**
     * 微信群id
     */
    @Field(type = FieldType.String, index = FieldIndex.not_analyzed)
    private String weixinGroupId;
    /**
     * 微信群头像
     */
    private String qrcodeHeadUrl;
    /**
     * 二维码地址
     */
    private String qrcodeUrl;
    /**
     * 使用状态1：已使用（人数未满）  2：人数已满
     */
    private Integer useState;
    /**
     * 群二维码状态（1 使用中 2 达到限制）
     */
    private Integer qrcodeState;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 最后修改人
     */
    private Long updateUser;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    /**
     * 0:未删除  1:已删除
     */
    private Integer isDelete;
    /**
     * 猜谜语是否开启
     */
    private Integer riddleOpen;

    /**
     * 城市标签
     */
    @Field(type = FieldType.String, index = FieldIndex.analyzed,analyzer = "ik_smart",searchAnalyzer = "ik_smart")
    private List<String> cityTags;

    /**
     * 群名标签
     */
    @Field(type = FieldType.String,index = FieldIndex.analyzed,analyzer = "ik_smart",searchAnalyzer = "ik_smart")
    private List<String> groupNameTags;

    /**
     * 书名标签
     */
    @Field(type = FieldType.String,index = FieldIndex.analyzed,analyzer = "ik_smart",searchAnalyzer = "ik_smart")
    private List<String> bookNameTags;

    /**
     * 出版社地区标签
     */
    @Field(type = FieldType.String,index = FieldIndex.analyzed,analyzer = "ik_smart",searchAnalyzer = "ik_smart")
    private List<String> pressTags;

    /**
     * 男性人数
     */
    private Integer maleCount;

    /**
     * 女性人数
     */
    private Integer femaleCount;

    /**
     * 未知性别人数
     */
    private Integer unknownCount;

    /**
     * 书名
     */
    @Field(type = FieldType.String,index = FieldIndex.analyzed,analyzer = "ik_smart",searchAnalyzer = "ik_smart")
    private String qrcodeBookName;

    /**
     * 群内实付总额 - ES 不支持 BigDecimal 类型
     */
    @Field(type = FieldType.String,index = FieldIndex.not_analyzed)
    private String purchaseAmount;

    /**
     * 群内实付订单总量
     */
    private Long purchaseVolume;

    /**
     * 群内实付总人数
     */
    private Long amountActuallyPaid;

    /**
     * 编辑名称
     */
    @Field(type = FieldType.String,index = FieldIndex.not_analyzed)
    private String adviserName;

    /**
     * 出版社名称
     */
    @Field(type = FieldType.String,index = FieldIndex.analyzed,analyzer = "ik_smart",searchAnalyzer = "ik_smart")
    private String agentName;

    /**
     * 图书ISBN
     */
    @Field(type = FieldType.String,index = FieldIndex.not_analyzed)
    private String isbn;

    /**
     * 成员总人数
     */
    private Integer groupMemberCount;
}

