package com.pcloud.book.giftcoupon.facade;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.cultivate.biz.CultivateBiz;
import com.pcloud.book.cultivate.dto.CreateCultivateDTO;
import com.pcloud.book.cultivate.dto.EnergyConsumptionDTO;
import com.pcloud.book.cultivate.dto.FishBallConversionDTO;
import com.pcloud.book.cultivate.dto.FishBallPickDTO;
import com.pcloud.book.cultivate.dto.GiveEnergyDTO;
import com.pcloud.book.cultivate.dto.HoldSeatDTO;
import com.pcloud.book.cultivate.dto.SkillUseDTO;
import com.pcloud.book.cultivate.entity.CultivateBookUser;
import com.pcloud.book.cultivate.entity.CultivateRobotClassify;
import com.pcloud.book.giftcoupon.biz.GiftCouponPackageBiz;
import com.pcloud.book.giftcoupon.dto.BatchReceiveDTO;
import com.pcloud.book.giftcoupon.dto.GiftPackageDTO;
import com.pcloud.book.giftcoupon.dto.GiftReceiveDTO;
import com.pcloud.book.giftcoupon.dto.MyGiftPackageDTO;
import com.pcloud.book.giftcoupon.entity.GiftCouponPackage;
import com.pcloud.book.giftcoupon.entity.GiftReceive;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

import javax.ws.rs.POST;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api("专享礼券包")
@RestController("giftCouponPackageFacade")
@RequestMapping("giftCouponPackage")
public class GiftCouponPackageFacade {
    @Autowired
    private GiftCouponPackageBiz giftCouponPackageBiz;



    @ApiOperation("新增礼券包")
    @PostMapping("/createGiftPackage")
    public ResponseDto<?> createGiftPackage(
            @RequestHeader("token") String token,
            @RequestBody GiftCouponPackage giftCouponPackage
    ) throws BizException, PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        giftCouponPackage.setAgentId(agentId);
        giftCouponPackageBiz.createGiftPackage(giftCouponPackage);
        return new ResponseDto<>();
    }

    @ApiOperation("修改礼券包")
    @PostMapping("/updateGiftPackage")
    public ResponseDto<?> updateGiftPackage(
            @RequestBody GiftCouponPackage giftCouponPackage
    ) throws BizException, PermissionException {
        giftCouponPackageBiz.updateGiftPackage(giftCouponPackage);
        return new ResponseDto<>();
    }

    @ApiOperation("获取礼券包")
    @GetMapping("/getGiftPackage")
    public ResponseDto<?> getGiftPackage(
            @RequestParam("id") @ApiParam("礼券包id") Long id
    ) throws BizException, PermissionException {
        return new ResponseDto<>(giftCouponPackageBiz.getGiftPackage(id));
    }

    @ApiOperation("删除礼券包")
    @GetMapping("/deleteGiftPackage")
    public ResponseDto<?> deleteGiftPackage(
            @RequestParam("id") @ApiParam("礼券包id") Long id
    ) throws BizException, PermissionException {
        giftCouponPackageBiz.deleteGiftPackage(id);
        return new ResponseDto<>();
    }

    @ApiOperation("礼券包列表")
    @GetMapping("/list4GiftPackage")
    public ResponseDto<PageBeanNew<GiftPackageDTO>> list4GiftPackage(
            @RequestHeader("token") String token,
            @RequestParam(value = "title",required = false) @ApiParam("礼包券名称") String title,
            @RequestParam(value = "state",required = false) @ApiParam("状态") Integer state,
            @RequestParam(value = "couponType",required = false) @ApiParam("券类型") Integer couponType,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage
    ) throws BizException, PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(giftCouponPackageBiz.list4GiftPackage(title,state,couponType,currentPage,numPerPage,agentId));
    }

    @ApiOperation("新增礼券包领取")
    @PostMapping("/createGiftReceive")
    public ResponseDto<?> createGiftReceive(
            @CookieValue(value = "userInfo") String  userInfo ,
            @RequestBody GiftReceive GiftReceive
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        GiftReceive.setWechatUserId(wechatUserId);
        giftCouponPackageBiz.createGiftReceive(GiftReceive);
        return new ResponseDto<>();
    }

    @ApiOperation("礼券包一键领取")
    @PostMapping("/createGiftReceiveBatch")
    public ResponseDto<?> createGiftReceiveBatch(
            @CookieValue(value = "userInfo") String  userInfo ,
            @RequestBody BatchReceiveDTO batchReceiveDTO
            ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        giftCouponPackageBiz.createGiftReceiveBatch(batchReceiveDTO,wechatUserId);
        return new ResponseDto<>();
    }

    @ApiOperation("我的礼券包列表")
    @GetMapping("/list4MyGiftPackage")
    public ResponseDto<PageBeanNew<MyGiftPackageDTO>> list4MyGiftPackage(
            @CookieValue(value = "userInfo") String  userInfo ,
            @RequestParam(value = "state", required = false) Integer state,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(giftCouponPackageBiz.list4MyGiftPackage(state,wechatUserId,currentPage,numPerPage));
    }

    @ApiOperation("券包使用")
    @PostMapping("/useGiftCoupon")
    public ResponseDto<?> useGiftCoupon(
            @CookieValue(value = "userInfo") String  userInfo ,
            @RequestBody GiftReceiveDTO giftReceiveDTO
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        giftCouponPackageBiz.useGiftCoupon(wechatUserId,giftReceiveDTO.getReceiveId());
        return new ResponseDto<>();
    }

    @ApiOperation("根据链接地址获取外链编号")
    @GetMapping("getUrlNumberByUrl")
    public ResponseDto<String> getUrlNumberByUrl(
            @RequestHeader("token") String token, @RequestParam(value = "url",required = false) String url){
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(giftCouponPackageBiz.getUrlNumberByUrl(url,agentId));
    }

    @ApiOperation("兑换券使用分析")
    @GetMapping("/listGiftPackage4Analysis")
    public ResponseDto<PageBeanNew<GiftPackageDTO>> listGiftPackage4Analysis(
            @RequestHeader("token") String token,
            @RequestParam(value = "title",required = false) @ApiParam("名称/链接编号") String title,
            @RequestParam(value = "state",required = false) @ApiParam("状态") Integer state,
            @RequestParam(value = "couponType",required = false) @ApiParam("券类型") Integer couponType,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam(value = "clickQty", required = false) @ApiParam("点击量") Integer clickQty,
            @RequestParam(value = "linkOnly",required = false) @ApiParam("只看第三方") Integer linkOnly
    ) throws BizException, PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(giftCouponPackageBiz.listGiftPackage4Analysis(title, state, couponType, currentPage, numPerPage, linkOnly,clickQty, agentId));
    }

}
