package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.keywords.vo.ListKeywordVO;
import com.pcloud.common.dto.BaseDto;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @描述：出版端书刊社群码数据
 * @作者：zhuyajie
 * @创建时间：14:40 2020/1/6
 * @版本：1.0
 */
@Data
@ApiModel("出版端书刊社群码数据")
public class BookGroupStatistic4AgentDTO extends BaseDto {

    @ApiModelProperty("社群书id")
    private Long bookGroupId;

    @ApiModelProperty("群二维码图片")
    private String groupQrcodeUrl;

    @ApiModelProperty("群二维码名称")
    private String groupQrcodeName;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("进群方式")
    private Integer joinGroupType;

    @ApiModelProperty("浏览量")
    private Integer browseCount;

    @ApiModelProperty("浏览人数")
    private Integer browserCount;

    @ApiModelProperty("平均浏览时长")
    private Long avgbrowseTimes;

    @ApiModelProperty("购买次数")
    private Long saleCount;

    @ApiModelProperty("销售额")
    private Double saleAmount;

    /**
     * 个人号列表
     */
    private List<AltAndCountDTO> altAndCountDTOS;

    /**
     * 个人号配置资源数据统计
     */
    private List<BookGroupServe> bookGroupServeList;
}
