package com.pcloud.book.rightsSetting.dao;

import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.common.core.dao.BaseDao;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/19 17:44
 **/
public interface RightsNowItemDao extends BaseDao<RightsNowItem> {

    Integer batchInsert(List<RightsNowItem> list);

    void deleteByRightsSettingId(Long rightsSettingId);

    List<RightsNowItem> getListByRightsSettingId(Long rightsSettingId,List<Integer> types);

    List<RightsNowItem> getGiftCouponListByRightsSettingId(Long id);

    List<RightsNowItem> getListByGroupIds(List<Long> groupIds);

    List<RightsNowItem> getListByRightsSettingTitleId(Long rightsSettingTitleId, List<Integer> types);

    List<RightsNowItem> getGiftCouponListByRightsSettingTitleId(Long id);

    List<Long> getAdviserGroupIds(List<Long> ids);

    List<Long> getActivityGroupIds(List<Long> ids);

    /**
     * 删除无效（删除或者下架）的资讯
     *
     * @param newsIds
     */
    void deleteInvalidNews(List<Long> newsIds);

    /**
     * 通过资讯id查询
     *
     * @param newsIds
     * @return
     */
    List<RightsNowItem> getByNewsIds(List<Long> newsIds);
}
