package com.pcloud.book.group.dao;

import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.group.dto.AltAndCountDTO;
import com.pcloud.book.group.dto.BookGroupIdAndCountDTO;
import com.pcloud.book.group.dto.CountAndTimeDTO;
import com.pcloud.book.group.dto.DayCountDTO;
import com.pcloud.book.group.dto.LabelUserCountDTO;
import com.pcloud.book.group.dto.SelfRobotBookGroupDTO;
import com.pcloud.book.group.dto.SelfRobotUserDTO;
import com.pcloud.book.group.entity.BookGroupCipherUser;
import com.pcloud.book.group.vo.UserBookInfoItemVO;
import com.pcloud.book.group.vo.UserBookInfoVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/24 15:18
 **/
public interface BookGroupCipherUserDao extends BaseDao<BookGroupCipherUser> {

    Long getBookGroupIdByWxUserId(String wxUserId);

    /**
     * 社群码好友数量
     * @param bookGroupId
     * @return
     */
    public Integer getFriendsCountByBookGroup(Long bookGroupId);

    /**
     * 日加好友数量
     * @param bookGroupId
     * @param startTime
     * @param endTime
     * @return
     */
    List<DayCountDTO> getBookGroupFriendsCountByDay(Long bookGroupId, String startTime, String endTime);
    /**
     * 根据时间查社群码好友数量
     * @param bookGroupId
     * @return
     */
    public Integer getFriendsCountByBookGroupByTime(Long bookGroupId, String startTime, String endTime);

    /**
     * 查询社群书关联的用户id集合
     */
    List<BookGroupCipherUser> getWxUserIdAndAltsByBookGroupId(Long bookGroupId);

    /**
     * 1v1社群码下用户id
     * @param bookGroupId
     * @return
     */
    List<String> getFriendIdsByBookGroupId(Long bookGroupId);

    /**
     * 用户扫描的社群书
     * @param wxUserId
     * @param altId
     * @return
     */
    public List<BookDto> getBookGroupListByUser(String wxUserId, String altId);

    /**
     * 获取个人号累计加好友人数
     */
    Integer getAddFriendCount();

    /**
     * 根据时间段获取个人号加好友人数
     */
    List<CountAndTimeDTO> getAddFriendCountByTime(Integer timeType, String startTime, String endTime);

    /**
     * 个人号读者统计
     * @param paramMap
     * @return
     */
    public List<SelfRobotUserDTO> listPageFriendInfo(Map<String, Object> paramMap);

    /**
     * 获取个人号读者专业或深度分布
     */
    List<LabelUserCountDTO> getUserLabelDistribution(Integer type, List<String> altIds);

    /**
     * 根据社群码获取小号
     */
    List<BookGroupCipherUser> getAltIdByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 根据bookGroupIds获取累计加好友人数
     */
    List<BookGroupIdAndCountDTO> getAddFriendByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 根据社群码id集合获取小号和用户id
     */
    List<BookGroupCipherUser> getWxUserIdAndAltsByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 根据小号获取服务社群书数量
     */
    List<AltAndCountDTO> getBookGroupCountListByAltIds(List<String> altIds);

    /**
     * 获取小号社群书数量
     */
    List<Long> getBookGroupIdsByAltIds(List<String> altIds);

    /**
     * 根据出版社id获取小号id集合
     */
    List<String> getAltIdsByAgentId(Long agentId);

    /**
     * 用户扫码的社群书信息
     * @param wxUserId
     * @param altId
     * @return
     */
    List<UserBookInfoItemVO> getScanBookInfoByUser(String wxUserId, String altId);

    /**
     * 个人号推送好友查询
     * @param map
     * @return
     */
    public List<UserBookInfoVO> listUser4SelfPush(Map<String,Object> map);

    /**
     * 查小号的好友id
     * @param altId
     * @param bookIds
     * @return
     */
    public List<String> getFriendIdListByBookAndRobot(String altId, List<Long> bookIds);

    /**
     * 获取与社群书关联的小号数量
     * @param bookGroupId
     * @return
     */
    Integer getAltCountByBookGroup(Long bookGroupId);

    /**
     * 社群书关联的小号及好友数量
     * @param bookGroupId
     * @return
     */
    List<AltAndCountDTO> getAltFriendList(Long bookGroupId);

    /**
     * 根据wxUserId获取
     */
    BookGroupCipherUser getByWxUserId(String wxUserId);

    /**
     * 根据用户和社群书id获取个人号信息
     * @param wxUserId
     * @param bookGroupId
     * @return
     */
    SelfRobotBookGroupDTO getSelfRobotBookGroupInfoByUser(String wxUserId, Long bookGroupId);
}
