package com.pcloud.book.keywords.dao;

import com.pcloud.book.keywords.dto.MaxSeqNAndBGDTO;
import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/12/30 11:39
 **/
public interface SelfRobotKeywordDao extends BaseDao<SelfRobotKeyword> {
    Integer batchInsert(List<SelfRobotKeyword> selfRobotKeywords);

    void updateSelfRobotKeyword(SelfRobotKeyword selfRobotKeyword);

    void deleteByBookGroupIds(List<Long> bookGroupIds);

    List<SelfRobotKeyword> getListByBookGroupId(Long bookGroupId);

    SelfRobotKeyword getByBookGroupIdAndKeyword(Long bookGroupId, String keyword);

    Integer getCountByBookGroupId(Long bookGroupId);

    List<MaxSeqNAndBGDTO> getMaxSeqNumByBookGroupIds(List<Long> bookGroupIds);

    void updateSeqNum(Long id, Integer seqNum);

    List<String> getKeywords(Long bookGroupId);
}
