package com.pcloud.book.keywords.facade;

import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Api(description = "个人号关键词")
public interface SelfRobotKeywordFacade {


    @ApiOperation("批量新增个人号关键词")
    @PostMapping("batchAddSelfRobotKeyword")
    ResponseDto<?> batchAddSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") List<SelfRobotKeyword> selfRobotKeywords
    ) throws BizException, PermissionException;

    @ApiOperation("更新个人号关键词")
    @PostMapping("updateSelfRobotKeyword")
    ResponseDto<?> updateSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") SelfRobotKeyword selfRobotKeyword
    ) throws BizException, PermissionException;

    @ApiOperation("删除个人号关键词")
    @GetMapping("deleteSelfRobotKeyword")
    ResponseDto<?> deleteSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("个人号关键词id") Long id
    ) throws BizException, PermissionException;

    @ApiOperation("获取个人号关键词列表")
    @GetMapping("getSelfRobotKeywordList")
    ResponseDto<?> getSelfRobotKeywordList(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam(value = "keyword",required = false) @ApiParam("关键词") String keyword,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("客户端获取个人号关键词列表")
    @GetMapping("getSelfRobotKeywordList4Wechat")
    ResponseDto<?> getSelfRobotKeywordList4Wechat(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam(value = "keyword",required = false) @ApiParam("关键词") String keyword,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("修改个人号关键词排序值")
    @PostMapping("updateSelfRobotKeywordSeqNum")
    ResponseDto<?> updateSelfRobotKeywordSeqNum(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") SelfRobotKeyword selfRobotKeyword
    ) throws BizException, PermissionException;

    @ApiOperation("获取应用或作品链接")
    @GetMapping("getAppOrProductServeUrl")
    ResponseDto<?> getAppOrProductServeUrl(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam("serveId") @ApiParam("作品或应用id") Long serveId,
            @RequestParam("serveType") @ApiParam("作品或应用类型") String serveType,
            @RequestParam("serveUrl") @ApiParam("作品或应用链接") String serveUrl
    ) throws BizException, PermissionException;

    @ApiOperation("获取最大关键词")
    @GetMapping("getMaxKeyword")
    ResponseDto<?> getMaxKeyword(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId
    ) throws BizException, PermissionException;
}
