package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.LearningReportBiz;
import com.pcloud.book.group.entity.LearningReportBrowseRecord;
import com.pcloud.book.group.facade.LearningReportFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController("learningReportFacade")
@RequestMapping("learningReport")
public class LearningReportFacadeImpl implements LearningReportFacade {

    @Autowired
    private LearningReportBiz learningReportBiz;

    @ApiOperation("新增学习报告浏览记录")
    @PostMapping("createLearningReportBrowseRecord")
    @Override
    public ResponseDto<?> createLearningReportBrowseRecord(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("学习报告浏览记录") LearningReportBrowseRecord learningReportBrowseRecord
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        learningReportBrowseRecord.setCreateUser(wechatUserId);
        return new ResponseDto<>(learningReportBiz.createLearningReportBrowseRecord(learningReportBrowseRecord));
    }

    @ApiOperation("获取最近学习记录")
    @GetMapping("getRecentlyLearning")
    @Override
    public ResponseDto<?> getRecentlyLearning(
            @CookieValue("userInfo") String userInfo,
            @RequestParam @ApiParam("群id") Long qrcodeId
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(learningReportBiz.getRecentlyLearning(wechatUserId,qrcodeId));
    }

    @ApiOperation("获取学习元气值前五名")
    @GetMapping("getLearningTopFive")
    @Override
    public ResponseDto<?> getLearningTopFive(
            @CookieValue("userInfo") String userInfo,
            @RequestParam @ApiParam("群id") Long qrcodeId
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(learningReportBiz.getLearningTopFive(qrcodeId));
    }

    @ApiOperation("获取微信用户元气值")
    @GetMapping("getUserLearningSore")
    @Override
    public ResponseDto<?> getUserLearningSore(
            @CookieValue("userInfo") String userInfo,
            @RequestParam @ApiParam("群id") Long qrcodeId
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(learningReportBiz.getUserLearningSore(qrcodeId, wechatUserId));
    }

    @ApiOperation("获取微信用户榜单")
    @GetMapping("getUserLearningInfo")
    @Override
    public ResponseDto<?> getUserLearningInfo(
            @CookieValue("userInfo") String userInfo,
            @RequestParam @ApiParam("群id") Long qrcodeId,
            @RequestParam @ApiParam("生成二维码的链接") String qrcodeUrlS
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(learningReportBiz.getUserLearningInfo(qrcodeId, wechatUserId,qrcodeUrlS));
    }
}
