package com.pcloud.book.pcloudkeyword.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotClassifyBiz;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotClassifyDao;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotWelcomeDao;
import com.pcloud.book.pcloudkeyword.dto.ClassifyWelcomeDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;

import com.pcloud.book.pcloudkeyword.set.PcloudRobotSet;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.QrcodeUtils;
import com.pcloud.common.utils.httpclient.UrlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;

@Service
public class PcloudRobotClassifyBizImpl implements PcloudRobotClassifyBiz {

    @Resource
    private PcloudRobotClassifyDao pcloudRobotClassifyDao;
    @Value("${wechat.group.link.prefix}")
    private String wechatLinkPrefix;
    @Resource
    private PcloudRobotWelcomeDao pcloudRobotWelcomeDao;
    @Autowired
    private PcloudRobotSet pcloudRobotSet;

    @Override
    public List<PcloudRobotClassifyResponseVO> listAllRobotClassify() {
        return pcloudRobotClassifyDao.listAllRobotClassify();
    }

    @Override
    public void saveRobotClassify(String classifyName) {
        PcloudRobotClassify classify = new PcloudRobotClassify();
        classify.setClassifyName(classifyName);
        classify.setIsDelete(0);
        pcloudRobotClassifyDao.insert(classify);
        String linkUrl = wechatLinkPrefix + "/group/info?classify_id=" + classify.getId();
        String codeUrl = QrcodeUtils.create( UrlUtils.getShortUrl4Own(linkUrl));
        classify.setLinkUrl(linkUrl);
        classify.setQrcodeUrl(codeUrl);
        pcloudRobotClassifyDao.update(classify);
    }

    @Override
    public void updateRobotClassify(PcloudRobotClassify classify) {
        pcloudRobotClassifyDao.update(classify);
    }

    @Override
    public PcloudRobotClassify getClassifyById(Long id) {
        return pcloudRobotClassifyDao.getById(id);
    }

    @Override
    public PageBeanNew<PcloudRobotClassifyResponseVO> listClassifyByPage(Integer currentPage, Integer numPerPage) {
        return pcloudRobotClassifyDao.listPageNew(new PageParam(currentPage, numPerPage), new HashMap<>(),"listClassifyByPage");
    }

    @Override
    public ClassifyWelcomeDTO getClassifyWelcome(Long classifyId) {
        ClassifyWelcomeDTO classifyWelcomeDTO = new ClassifyWelcomeDTO();
        PcloudRobotClassify robotClassify = pcloudRobotClassifyDao.getById(classifyId);
        classifyWelcomeDTO.setIsOpenPushH5url(robotClassify.getIsOpenPushH5url());
        classifyWelcomeDTO.setWelcomeDuration(robotClassify.getWelcomeDuration());
        List<PcloudRobotWelcome> pcloudRobotWelcomeList = pcloudRobotWelcomeDao.getRobotWelcomeListByPcloudClassifyId(classifyId);
        pcloudRobotSet.fillRobotWelcome(pcloudRobotWelcomeList);
        classifyWelcomeDTO.setPcloudRobotWelcomeList(pcloudRobotWelcomeList);
        return classifyWelcomeDTO;
    }

    @Override
    public void updateClassifyWelcome(ClassifyWelcomeDTO classifyWelcomeDTO) {
        pcloudRobotClassifyDao.updateWelcomeDuration(classifyWelcomeDTO.getPcloudClassifyId(), classifyWelcomeDTO.getWelcomeDuration(),classifyWelcomeDTO.getIsOpenPushH5url());
        List<PcloudRobotWelcome> robotWelcomeList = classifyWelcomeDTO.getPcloudRobotWelcomeList();
        pcloudRobotWelcomeDao.deleteByPcloudClassifyId(classifyWelcomeDTO.getPcloudClassifyId());
        if (ListUtils.isEmpty(robotWelcomeList)) {
            return;
        }
        pcloudRobotWelcomeDao.batchInsert(robotWelcomeList);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateRobotClassifyKeywordClassify(PcloudRobotClassify classify) {
        if (classify==null||classify.getId()==null||classify.getKeywordClassifyId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        pcloudRobotClassifyDao.updateRobotClassifyKeywordClassify(classify.getId(),classify.getKeywordClassifyId());
    }

}
