/**
 *
 */
package com.pcloud.book.book.service;

import com.pcloud.book.book.dto.BookAdviserUpdateTimeDTO;
import com.pcloud.book.book.dto.BookDetialDTO;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookInfo4AnlysicsDTO;
import com.pcloud.book.book.dto.BookInfoAnalysicsDTO;
import com.pcloud.book.book.dto.BookInfoAndAuthStatusDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2016年12月23日,下午5:27:09 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookServiceCloud", path = "book/v1.0/bookService")
@Api(description = "书籍内部服务")
public interface BookService {

    /**
     * 获取书籍信息
     *
     * @param bookId
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取书籍信息", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getBaseById", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookDto>> getBaseById(@RequestParam(value = "bookId", required = false) Long bookId)
            throws BizException;

    /**
     * 批量获取书籍信息
     *
     * @param bookIds
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "批量获取书籍信息", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookIds", value = "图书id集合", dataType = "List<Long>", paramType = "body")})
    @RequestMapping(value = "/getListByIds", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, BookDto>>> getListByIds(@RequestBody(required = false) List<Long> bookIds)
            throws BizException;


    /**
     * 批量获取书籍信息（书名 与书刊序号 封面图）
     *
     * @param bookIds
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "批量获取书籍信息（书名 与书刊序号 封面图）", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookIds", value = "图书id集合", dataType = "List<Long>", paramType = "body")})
    @RequestMapping(value = "/listBaseByIds", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, BookDto>>> listBaseByIds(@RequestBody(required = false) List<Long> bookIds)
            throws BizException;

    @ApiOperation(value = "批量获取书籍信息（书名 模板ID ）", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookDetialDTO", value = "图书id集合", dataType = "BookDetialDTO", paramType = "body")})
    @RequestMapping(value = "/listDetailByIds", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<String, BookDto>>> listDetailByIds(@RequestBody(required = false) BookDetialDTO bookDetialDTO)
            throws BizException;

    /**
     * 根据名称获取ID
     *
     * @param bookName
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "根据名称获取ID", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookName", value = "图书名称", dataType = "string", paramType = "query")})
    @RequestMapping(value = "/getIdsByName", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<List<Long>>> getIdsByName(
            @RequestParam(value = "bookName", required = false) String bookName) throws BizException;
    
    /**
     * 根据名称获取ID
     *
     * @param bookName
     * @param adviserId
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "根据名称获取ID", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookName", value = "图书名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getIdsByName2", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<List<Long>>> getIdsByName(
            @RequestParam(value = "bookName", required = true) String bookName,
            @RequestParam(value = "adviserId", required = true) Long adviserId) throws BizException;

    /**
     * 根据ISBN码获取书籍 to exapi
     *
     * @param isbn
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "根据ISBN码获取书籍  to exapi", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "serialNumber", value = "刊物序号", dataType = "string", paramType = "query")})
    @RequestMapping(value = "/getByIsbn", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookDto>> getByIsbn(@RequestParam(value = "isbn", required = false) String isbn,
                                                   @RequestParam(value = "serialNumber", required = false) String serialNumber) throws BizException;

    /**
     * 根据ISBN码获取书籍详情（包含二维码个数，应用个数，商品个数） to exapi
     *
     * @param isbn
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "根据ISBN码获取书籍详情（包含二维码个数，应用个数，商品个数） to exapi", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "serialNumber", value = "刊物序号", dataType = "string", paramType = "query")})
    @RequestMapping(value = "/getDetailByIsbn", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookDto>> getDetailByIsbn(@RequestParam(value = "isbn", required = false) String isbn,
                                                         @RequestParam(value = "serialNumber", required = false) String serialNumber) throws BizException;

    /**
     * 获取应用关联的图书
     *
     * @param appId     应用标识
     * @param channelId 渠道标识
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取应用关联的图书", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "appId", value = "应用标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/listBookByAppId", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<List<BookDto>>> listBookByAppId(
            @RequestParam(value = "appId", required = false) Long appId,
            @RequestParam(value = "channelId", required = false) Long channelId) throws BizException;
    
	/**
	 * 根据ISBN码获取书籍 to exapi
	 *
	 * @param isbn
	 * @return
	 * @throws BizException
	 */
	@ApiOperation(value = "根据ISBN码获取书籍 (全匹配)", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query") })
	@RequestMapping(value = "/listByIsbn", method = RequestMethod.GET)
	ResponseEntity<ResponseDto<Map<Long, BookDto>>> listByIsbn(@RequestParam(value = "isbn", required = false) String isbn)
			throws BizException;

	/**
     * 获取图书基本信息（编辑 - 运营 - 图书）
     *
     * @param adviserId  编辑标识
     * @param channelId 渠道标识
     * @param bookId 图书标识
     * @param 
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取图书基本信息（编辑 - 运营 - 图书）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query"),
    	    @ApiImplicitParam(name = "channelId", value = "运营标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getBookById", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookDto>> getBookById(
            @RequestParam(value = "adviserId") Long adviserId,
            @RequestParam(value = "channelId") Long channelId,
            @RequestParam(value = "bookId") Long bookId) throws BizException;

    /**
     * 获取图书类型标识（编辑 - 运营 - 图书）
     *
     * @param adviserId  编辑标识
     * @param channelId 渠道标识
     * @param bookId 图书标识
     * @param
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取图书类型标识（编辑 - 运营 - 图书）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "运营标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getBookTempletIdId", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<Long>> getBookTempletIdId(
            @RequestParam(value = "adviserId") Long adviserId,
            @RequestParam(value = "channelId") Long channelId,
            @RequestParam(value = "bookId") Long bookId) throws BizException;



    @ApiOperation(value = "修改图书时间", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/updateTimeById", method = RequestMethod.GET)
    public void updateTimeById(@RequestParam(value = "bookId")Long bookId)throws BizException;

    @ApiOperation(value = "修改图书时间--批量", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookIds", value = "图书标识", dataType = "List<Long>", paramType = "body")})
    @RequestMapping(value = "/updateTimeByIds", method = RequestMethod.POST)
    public void updateTimeByIds(@RequestBody BookAdviserUpdateTimeDTO bookAdviserUpdateTimeDTO)throws BizException;

    @ApiOperation(value = "获取书刊信息", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookInfoAnalysicsDTOS", value = "图书信息-书刊分析", dataType = "List<BookInfoAnalysicsDTO>", paramType = "body"),
            @ApiImplicitParam(name = "monthDate", value = "数据统计时间", dataType = "String", paramType = "query")})
    @RequestMapping(value = "/getBookInfoBy", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<String,BookInfoAnalysicsDTO>>> getBookInfoBy(@RequestBody List<BookInfoAnalysicsDTO> bookInfoAnalysicsDTOS,@RequestParam(value = "monthDate",required = false) String monthDate)throws BizException;


    @ApiOperation(value = "获取书刊信息", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookIds", value = "图书ID", dataType = "List<Long>", paramType = "body"),
            @ApiImplicitParam(name = "monthDate", value = "数据统计时间", dataType = "String", paramType = "query")})
    @RequestMapping(value = "/getBookAnalysis", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<Long,BookInfo4AnlysicsDTO>>> getBookAnalysis(@RequestBody List<Long> bookIds, @RequestParam(value = "monthDate",required = false)  String monthDate)throws BizException;

    @ApiOperation(value = "获取书籍信息", httpMethod = "GET")
    @RequestMapping(value = "/getBaseAndAuthStatus", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookInfoAndAuthStatusDTO>> getBaseAndAuthStatus(@RequestParam(value = "bookId") Long bookId, @RequestParam(value = "channelId") Long channelId,@RequestParam(value = "adviserId") Long adviserId)
            throws BizException;

    @ApiOperation("根据书名或isbn编号查询书")
    @RequestMapping(value = "/getIdsByNameOrISBN", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<List<Long>>> getIdsByNameOrISBN(
            @RequestParam(value = "keyword") String keyword,
            @RequestParam(value = "adviserId") Long adviserId
    ) throws BizException;

    @ApiOperation("根据书名模糊匹配，获得所有book_id")
    @RequestMapping(value = "/getBookIdsByBookName", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<List<Long>>> getBookIdsByBookName(
            @RequestParam(value = "bookName") String bookName
    ) throws BizException;
}
