package com.pcloud.book.clock.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.clock.biz.BookClockKeywordBiz;
import com.pcloud.book.clock.eneity.BookClockKeywordCheckParam;
import com.pcloud.book.clock.eneity.CancelSelectedParam;
import com.pcloud.book.clock.facade.BookClockKeywordFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:48
 * @Version 1.0
 */
@RequestMapping("/bookClockKeyword")
@RestController("bookClockKeywordFacade")
public class BookClockKeywordFacadeImpl implements BookClockKeywordFacade {

    @Autowired
    private BookClockKeywordBiz bookClockKeywordBiz;


    @Override
    @RequestMapping(value = "getKeywordBookClockList", method = RequestMethod.POST)
    public ResponseDto<?> getKeywordBookClockList(@RequestHeader String token, @RequestBody BookClockKeywordCheckParam bookClockKeywordCheckParam) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookClockKeywordCheckParam.setAdviserId(adviserId);
        if(null == bookClockKeywordCheckParam || StringUtil.isEmpty(bookClockKeywordCheckParam.getKeyword())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        return new ResponseDto<>(bookClockKeywordBiz.getKeywordBookClockList(bookClockKeywordCheckParam));
    }

    @Override
    @RequestMapping(value = "getKeywordBookClockList4HasSelected", method = RequestMethod.POST)
    public ResponseDto<?> getKeywordBookClockList4HasSelected(@RequestHeader String token, @RequestBody BookClockKeywordCheckParam bookClockKeywordCheckParam) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == bookClockKeywordCheckParam || StringUtil.isEmpty(bookClockKeywordCheckParam.getKeyword()) || null == bookClockKeywordCheckParam.getIsBookGroup()){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        if(null == bookClockKeywordCheckParam.getCurrentPage() || null == bookClockKeywordCheckParam.getNumPerPage()){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"分页参数有误");
        }
        bookClockKeywordCheckParam.setAdviserId(adviserId);
        return new ResponseDto<>(bookClockKeywordBiz.getKeywordBookClockList4HasSelected(bookClockKeywordCheckParam));
    }


    @Override
    @RequestMapping(value = "cancelSelected", method = RequestMethod.POST)
    public ResponseDto<?> cancelSelected(@RequestHeader String token,@RequestBody CancelSelectedParam cancelSelectedParam) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == cancelSelectedParam.getBookClockInfoId()){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        if(null == cancelSelectedParam.getBookGroupId() && null == cancelSelectedParam.getClassifyId()){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        bookClockKeywordBiz.cancelSelected(cancelSelectedParam);
        return new ResponseDto<>();
    }
}
