package com.pcloud.book.guide.facade.impl;


import com.pcloud.book.guide.biz.PcloudRobotWakeUpBiz;
import com.pcloud.book.guide.vo.RobotWakeUpConfigVO;
import com.pcloud.book.guide.vo.RobotWakeUpShowVO;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotClassifyBiz;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("robotWakeUp")
public class PcloudRobotWakeUpFacadeImpl {

    @Autowired
    private PcloudRobotWakeUpBiz pcloudRobotWakeUpBiz;
    @Autowired
    private PcloudRobotClassifyBiz pcloudRobotClassifyBiz;


    @ApiOperation(value = "机器人小号唤醒配置")
    @PostMapping("config")
    ResponseDto<?> robotWakeUpConfig(@RequestHeader String token, @RequestBody RobotWakeUpConfigVO robotWakeUpConfigVO) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        pcloudRobotWakeUpBiz.robotWakeUpConfig(robotWakeUpConfigVO);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "解除机器人小号唤醒配置")
    @PostMapping("remove")
    ResponseDto<?> robotWakeUpClose(@RequestHeader String token) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        pcloudRobotWakeUpBiz.robotWakeUpRemove();
        return new ResponseDto<>();
    }

    @ApiOperation(value = "获取机器人小号配置")
    @GetMapping("get")
    ResponseDto<?> getRobotWakeUpConfig(@RequestHeader String token) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(pcloudRobotWakeUpBiz.getRobotWakeUpConfig());
    }


    @ApiOperation(value = "平台端获取所有的个人号分类")
    @GetMapping("listClassify")
    ResponseDto<List<PcloudRobotClassifyResponseVO>> listClassify(@RequestHeader String token) throws PermissionException{
        SessionUtil.getToken4Redis(token);
        List<PcloudRobotClassifyResponseVO> classify = pcloudRobotWakeUpBiz.listAllClassify();
        return new ResponseDto<>(classify);
    }
}
