package com.pcloud.book.pcloudkeyword.biz.impl;

import com.pcloud.book.pcloudkeyword.biz.PcloudRobotClassifyBiz;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotClassifyDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;

import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;

@Service
public class PcloudRobotClassifyBizImpl implements PcloudRobotClassifyBiz {

    @Resource
    private PcloudRobotClassifyDao pcloudRobotClassifyDao;

    @Override
    public List<PcloudRobotClassifyResponseVO> listAllRobotClassify() {
        return pcloudRobotClassifyDao.listAllRobotClassify();
    }

    @Override
    public void saveRobotClassify(String classifyName) {
        PcloudRobotClassify classify = new PcloudRobotClassify();
        classify.setClassifyName(classifyName);
        classify.setIsDelete(0);
        pcloudRobotClassifyDao.insert(classify);
    }

    @Override
    public void updateRobotClassify(PcloudRobotClassify classify) {
        pcloudRobotClassifyDao.update(classify);
    }

}
