package com.pcloud.book.pcloudkeyword.entity;

import com.pcloud.common.entity.BaseEntity;
import com.pcloud.contentcenter.resource.dto.ResourceOfficeItemDTO;
import com.pcloud.contentcenter.resource.dto.ResourcePdfItemDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel("全平台个人号欢迎语")
@Data
public class PcloudRobotWelcome extends BaseEntity {

    @ApiModelProperty("全平台个人号id")
    private Long pcloudRobotId;

    @ApiModelProperty("类型 1 文字 2 图片 3音频 4PDF")
    private Integer replyType;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("图片url")
    private String picUrl;

    @ApiModelProperty("文件名称")
    private String fileName;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("文件路径")
    private String fileUrl;

    @ApiModelProperty("文件大小")
    private Long fileSize;

    @ApiModelProperty("资源id")
    private Long resourceId;

    @ApiModelProperty("资源链接")
    private String resourceUrl;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("资源类型编码")
    private String resourceTypeCode;

    @ApiModelProperty("资源类型名称")
    private String resourceTypeName;

    @ApiModelProperty("pdf转码后的单张图片集合")
    private List<ResourcePdfItemDTO> resourcePdfItems;

    @ApiModelProperty("文件转码后的单张图片集合")
    private List<ResourceOfficeItemDTO> resourceOfficeItemDTOs;



}
