package com.pcloud.book.pcloudkeyword.service.impl;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudKeyword.service.PcloudRobotService;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RequestMapping("pcloudRobotService")
@RestController("pcloudRobotService")
public class PcloudRobotServiceImpl implements PcloudRobotService {

    @Autowired
    private PcloudRobotBiz pcloudRobotBiz;

    @Override
    @PostMapping("getRobotClassifyBatch")
    public ResponseEntity<ResponseDto<Map<String, RobotClassifyDTO>>> getRobotClassifyBatch(@RequestBody List<String> robotIds) {
        return ResponseHandleUtil.toResponse(pcloudRobotBiz.mapByIds4Classify(robotIds));
    }

    @Override
    @GetMapping("getAllPcloudRobot")
    public ResponseEntity<ResponseDto<List<RobotClassifyDTO>>> getAllPcloudRobot() {
        return ResponseHandleUtil.toResponse(pcloudRobotBiz.getAllPcloudRobot());
    }
}
