package com.pcloud.book.reading.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("共读活动用户")
public class ReadingUser extends BaseEntity{

    @ApiModelProperty("共读活动id")
    private Long activityId;

    @ApiModelProperty("用户id")
    private String wxUserId;

    @ApiModelProperty("小号id")
    private String altId;

    @ApiModelProperty("参与状态")
    private Integer joinState;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("创建人")
    private Long createUser;

}