package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletGroupManageDTO;
import com.pcloud.book.applet.dto.AppletGroupStatementDTO;
import com.pcloud.book.applet.entity.AppletGroupSearchRecord;
import com.pcloud.book.skill.dto.GroupActivity4AppletDTO;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * (AppletGroupSearchRecord)表服务接口
 *
 * @author zyq
 * @since 2020-04-01 17:34:47
 */
public interface AppletGroupSearchRecordBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletGroupSearchRecord getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Long wechatUserId, Integer isMore, Integer currentPage, Integer numPerPage, Long agentId);

    /**
     * 新增数据
     *
     * @param appletGroupSearchRecord 实例对象
     * @return 主键
     */
    Long insert(AppletGroupSearchRecord appletGroupSearchRecord);

    /**
     * 修改数据
     *
     * @param appletGroupSearchRecord 实例对象
     */
    void update(AppletGroupSearchRecord appletGroupSearchRecord);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    void deleteByIds(List<Long> ids);

    List<GroupActivity4AppletDTO> getTishBookSchoolList(Long wechatUserId, Long bookGroupId, Long officialAccountsId);

    /**
     * 群对话随机组装
     * @author：zhuyajie
     * @date：2020/5/8 15:23
     *  * @param null
     */
    public List<AppletGroupStatementDTO> getStatementList(Integer userNum, List<String> headUrlList,Long groupQrcodeId);

    /**
     * 获取群头像
     * @author：zhuyajie
     * @date：2020/5/9
     *  * @param null
     */
    public List<String> getHeadUrlList(Integer userNum, Long groupQrcodeId);

    /**
     * 用户搜索记录id
     * @author：zhuyajie
     * @date：2020/5/29 13:06
     *  * @param null
     */
    List<Long> getRecordIdListByUser(Long wechatUserId);
    /**
     * 根据分类查社群-首页
     * @author：zhuyajie
     * @date：2020/6/8 14:45
     *  * @param null
     */
    PageBeanNew<AppletGroupManageDTO> getGroupList4AppletHome(Long wechatUserId, Integer currentPage, Integer numPerPage, Long officialAccountsId);

}