package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.BuyBookRequetUserDTO;
import com.pcloud.book.applet.entity.BuyBookRequest;
import com.pcloud.common.page.PageBeanNew;

/**
 * (BuyBookRequest)表服务接口
 *
 * @author makejava
 * @since 2020-10-14 19:51:41
 */
public interface BuyBookRequestBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BuyBookRequest getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param buyBookRequest 实例对象
     * @return 主键
     */
    Long insert(BuyBookRequest buyBookRequest);

    /**
     * 修改数据
     *
     * @param buyBookRequest 实例对象
     */
    void update(BuyBookRequest buyBookRequest);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 获取用户数量
     * @return
     * @param topCount
     */
    BuyBookRequetUserDTO getUserCount(Integer topCount);
}