package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletNewsCustomTagDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.book.applet.entity.AppletNewsCustomTag;
import com.pcloud.book.applet.vo.AppletNewsClassifyVO;
import com.pcloud.book.applet.vo.AppletNewsShowStateVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 小程序资讯
 */
public interface AppletNewsDao extends BaseDao<AppletNews> {

    /**
     * 根据名片id获取是否已经绑定微信
     * @param businessCardId
     * @return
     */
    Long getCountByBusinessCardId(Long businessCardId);


    /**
     * 根据分类查询
     * @param newsClassifyId
     * @return
     */
    List<AppletNews> getByNewsClassifyId(Long newsClassifyId);

    /**
     * 更新上架状态
     * @param appletNews
     */
    void updateNewsShowState(AppletNews appletNews);

    /**
     * 根据分类标签查资讯
     * @param firstClassify
     * @param secondClassify
     * @param gradeLabelId
     * @param subjectLabelId
     * @param rightsType
     * @return
     */
    List<AppletNewsDTO> getByNewsByTempletLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, String rightsType, Long agentId);

    List<AppletNews> getByTempletAndClassify(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long rightsClassifyId, Integer top,
                                             Long agentId);

    /**
     *新增资讯来源
     */
    void insertSource(String source, Long agentId);
    /**
     *资讯来源列表
     */
    List<String> getNewsSourceList(Long agentId);
    /**
     *资讯来源数量
     */
    Integer getAppletNewsSourceCount(String source, Long agentId);
    /**
     *删除资讯来源
     */
    void deleteSource(String source, Long agentId);
    /**
     *来源是否存在
     */
    Boolean newsSourceExist(String source, Long agentId);

    void batchUpdateClassify(AppletNewsClassifyVO appletNewsClassifyVO);

    void batchUpdateShowState(AppletNewsShowStateVO appletNewsShowStateVO);

    void batchDeleteAppletNews(List<Long> appletNewsIds);

    /**
     * 根据跳转地址查询
     * @author：zhuyajie
     * @date：2020/5/11 17:39
     *  * @param null
     */
    String getUrlNumberByJumpUrl(String jumpUrl, Long agentId);
    /**
     * 链接编号是否存在
     * @author：zhuyajie
     * @date：2020/5/11 18:43
     *  * @param null
     */
    Boolean urlNumberExist(String urlNumber, Long id, Long agentId);

    Map<Long, AppletNewsDTO> getByIds(List<Long> appletNewsIds);

    /**
     * 批量修改资讯栏目
     * @author：zhuyajie
     * @date：2020/5/26 19:07
     *  * @param null
     */
    void batchUpdateNewsClassify(AppletNewsClassifyVO appletNewsClassifyVO);

    /**
     * 批量更新自定义标识
     * @author：zhuyajie
     * @date：2020/6/9 17:52
     *  * @param null
     */
    void batchUpdateCustomTagId(List<Long> ids,Long customTagId);
    /**
     * 新增自定义标识
     * @author：zhuyajie
     * @date：2020/6/9 17:52
     *  * @param null
     */
    void insertCustomTag(AppletNewsCustomTag appletNewsCustomTag);
    /**
     * 修改自定义标识
     * @author：zhuyajie
     * @date：2020/6/9 17:52
     *  * @param null
     */
    void updateCustomTag(AppletNewsCustomTag appletNewsCustomTag);
    /**
     * 自定义标识列表
     * @author：zhuyajie
     * @date：2020/6/9 17:52
     *  * @param null
     */
    List<AppletNewsCustomTagDTO> getCustomTagList(Long agentId);
    /**
     * 标识是否存在
     * @author：zhuyajie
     * @date：2020/6/9 18:12
     *  * @param null
     */
    Boolean customTagExist(String customTag, Long agentId);
    /**
     * 根据标识id查资讯id列表
     * @author：zhuyajie
     * @date：2020/6/10 17:39
     *  * @param null
     */
    List<Long> getNewsIdListByCustomTagId(Long customTagId);

    /**
     * 获取资讯数量
     * @param paramMap
     * @return
     */
    Integer listAppletNews4WechatCount(Map<String, Object> paramMap);

    /**
     * 批量名片上下架
     * @param appletNewsShowStateVO
     */
    void batchUpdateCardShowState(AppletNewsShowStateVO appletNewsShowStateVO);


    /**
     * 更新上架状态
     * @param appletNews
     */
    void updateCardShowState(AppletNews appletNews);

    /**
     * 根据城市获取对应资讯
     * @param cityId
     */
    List<AppletNewsDTO> listNewsByCityCode(String cityId);

    /**
     * 删除资讯
     * @param newArrayList
     */
    void deleteByNews(List<Long> newArrayList);

    /**
     * 查询资讯 无论是否删除
     * @param newsIds
     * @return
     */
    Map<Long, AppletNewsDTO> getByIds4Record(List<Long> newsIds);
}
