package com.pcloud.book.book.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 平台端查询编辑书
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
@Data
public class PcloudAdviserBookVO implements Serializable {

    private static final long serialVersionUID = 5106914273592177686L;

    @ApiModelProperty("编辑")
    private String author;

    @ApiModelProperty("编辑对应的出版社名称")
    private String publish;

    @ApiModelProperty("书名")
    private String bookName;

    @ApiModelProperty("ISBN")
    private String isbn;

    @ApiModelProperty("图书封面")
    private String coverImg;

    @ApiModelProperty("图书ID")
    private Long bookId;

    @ApiModelProperty("bookAdviserId")
    private Long bookAdviserId;

    @ApiModelProperty("编辑ID")
    private Long adviserId;

    @ApiModelProperty("出版社ID")
    private Long agentId;


}
