package com.pcloud.book.timecontrol.vo.request;

import com.pcloud.book.timecontrol.entity.TimeControlPrizeItem;
import com.pcloud.book.timecontrol.enums.TaskPrizeItemTypeEnum;
import com.pcloud.common.utils.BeanUtils;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class CertificateRequestVO {
    @NotNull(message = "证书文案不能为空")
    private String certificateTitle;
    @NotNull(message = "证书落款不能为空")
    private String certificateUser;
    @NotNull(message = "证书图片链接不能为空")
    private String certificateBaseUrl;

    public static TimeControlPrizeItem valueToPrizeItem(SavePrize4TaskItemVO savePrize4TaskItemVO){
        TimeControlPrizeItem prizeItem = new TimeControlPrizeItem();
        CertificateRequestVO vo = savePrize4TaskItemVO.getCertificate();
        BeanUtils.copyProperties(vo, prizeItem);
        prizeItem.setTaskId(savePrize4TaskItemVO.getTaskId());
        prizeItem.setTaskItemId(savePrize4TaskItemVO.getTaskItemId());
        prizeItem.setPrizeType(TaskPrizeItemTypeEnum.CERTIFICATE.key);
        prizeItem.setCreateTime(new Date());
        return prizeItem;
    }
}
