package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/17 16:13
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class WeixinQrcodeDTO  implements Serializable {
    @ApiModelProperty("二维码ID")
    private Long id;

    @ApiModelProperty("二维码URL")
    private String qrcodeUrl;

    @ApiModelProperty("微信群标识")
    private String weixinGroupId;

    @ApiModelProperty("机器人标识")
    private Long robotId;

    @ApiModelProperty("机器人微信标识")
    private String robotWxId;

    @ApiModelProperty("用户数")
    private Integer userNumber;

    public Integer getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public Long getRobotId() {
        return robotId;
    }

    public void setRobotId(Long robotId) {
        this.robotId = robotId;
    }

    public String getRobotWxId() {
        return robotWxId;
    }

    public void setRobotWxId(String robotWxId) {
        this.robotWxId = robotWxId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public String getWeixinGroupId() {
        return weixinGroupId;
    }

    public void setWeixinGroupId(String weixinGroupId) {
        this.weixinGroupId = weixinGroupId;
    }

    @Override
    public String toString() {
        return "WeixinQrcodeDTO{" +
                "id=" + id +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", weixinGroupId='" + weixinGroupId + '\'' +
                ", robotId=" + robotId +
                ", robotWxId='" + robotWxId + '\'' +
                ", userNumber=" + userNumber +
                '}';
    }
}
