package com.pcloud.book.group.service;

import com.pcloud.book.group.dto.ReplyMsgDTO;
import com.pcloud.book.group.dto.WxWorkTeacherDTO;
import com.pcloud.common.dto.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifier = "wxWorkTeacherServiceCloud", path = "book/v1.0/wxWorkTeacherService")
@Api(description = "企业微信客服")
public interface WxWorkTeacherService {

    @ApiOperation("根据teacherIds获取企业微信客服")
    @PostMapping("/getWxWorkTeacherByIds")
    ResponseEntity<ResponseDto<Map<Long, WxWorkTeacherDTO>>> getWxWorkTeacherByIds(@RequestBody List<Long> teacherIds);

}
