package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.BrandDataDTO4Channel;
import com.pcloud.book.advertising.entity.AdvertisingBrandData;
import com.pcloud.common.core.dao.BaseDao;

import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 品牌方数据修改(AdvertisingBrandData)表数据库访问层
 *
 * @author zhuyajie
 * @since 2020-04-16 11:39:50
 */
public interface AdvertisingBrandDataDao extends BaseDao<AdvertisingBrandData> {

    /**
     * 通过实体作为筛选条件查询
     *
     * @param advertisingBrandData 实例对象
     * @return 对象列表
     */
    List<AdvertisingBrandData> queryAll(AdvertisingBrandData advertisingBrandData);

    /**
     * 二维码资源数据
     * @param brandDataDTO4Channel
     * @return
     */
    List<AdvertisingBrandData> getQrServeData4Channel(BrandDataDTO4Channel brandDataDTO4Channel);

    /**
     * 二维码数据
     * @param brandDataDTO4Channel
     * @return
     */
    List<AdvertisingBrandData> getQrData4Channel(BrandDataDTO4Channel brandDataDTO4Channel);

    List<AdvertisingBrandData> getBookAddByType(List<Long> bookIds,String addType);
}