package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 个人阅读报告总结(AppletRecordStatisReport)实体类
 *
 * @author makejava
 * @since 2020-12-11 16:22:46
 */
@Data
public class AppletRecordStatisReportDTO {

    @ApiModelProperty("个人阅读报告总结主键")
    private Long id;
    
    @ApiModelProperty("用户id")
    private Long wechatUserId;
    
    @ApiModelProperty("统计开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate;
    
    @ApiModelProperty("统计结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
    
    @ApiModelProperty("评分")
    private BigDecimal score;
    
    @ApiModelProperty("比上周")
    private BigDecimal compareScore;

    @ApiModelProperty("超过的用户占比")
    private BigDecimal compareUserRatio;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
}
