package com.pcloud.book.giftcoupon.dto;

import com.pcloud.book.giftcoupon.entity.GiftCategory;
import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;

import java.util.List;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class BatchUpdateDTO {
    @ApiModelProperty("1-上下架，2-批量配置分类")
    @NotNull(message = "批量操作字段不能为空")
    private Integer operateType;

    @ApiModelProperty("上下架")
    private Boolean onShelves;

    @ApiModelProperty("分类")
    private List<BaseTempletClassify> categoryList;


    @ApiModelProperty("id集合")
    @NotNull(message = "礼包券id不能为空")
    private List<Long> packageIds;

}
