package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/24 15:07
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class LearningScoreDTO implements Serializable {
    private static final long serialVersionUID = 3667715938819008003L;

    @ApiModelProperty("微信id")
    private Long wechatUserId;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("头像")
    private String headUrl;

    @ApiModelProperty("元气值")
    private Integer score;

    @ApiModelProperty("总学习时长")
    private Integer allLearningTime;

    public Long getWechatUserId() {
        return wechatUserId;
    }

    public void setWechatUserId(Long wechatUserId) {
        this.wechatUserId = wechatUserId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadUrl() {
        return headUrl;
    }

    public void setHeadUrl(String headUrl) {
        this.headUrl = headUrl;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Integer getAllLearningTime() {
        return allLearningTime;
    }

    public void setAllLearningTime(Integer allLearningTime) {
        this.allLearningTime = allLearningTime;
    }

    @Override
    public String toString() {
        return "LearningScoreDTO{" +
                "wechatUserId=" + wechatUserId +
                ", nickName='" + nickName + '\'' +
                ", headUrl='" + headUrl + '\'' +
                ", score=" + score +
                ", allLearningTime=" + allLearningTime +
                '}';
    }
}
