package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletBookClassifyDTO;
import com.pcloud.book.applet.dto.AppletBookClassifyRelationDTO;
import com.pcloud.book.applet.entity.AppletBookClassify;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 小程序客户端书刊分类(AppletBookClassify)表数据库访问层
 *
 * @author makejava
 * @since 2020-05-15 16:10:59
 */
public interface AppletBookClassifyDao extends BaseDao<AppletBookClassify>{

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletBookClassify queryById(Long id);

    /**
     * 条件查询
     *
     * @return 对象列表
     */
    List<AppletBookClassifyDTO> queryAll(Boolean showState);


    /**
     * 关联书刊一级分类
     * @author：zhuyajie
     * @date：2020/5/18 14:18
     *  * @param null
     */
    void addBookClassifyRelation (List<AppletBookClassifyRelationDTO> bookClassifyRelations);

    /**
     * 查关联书刊分类
     * @author：zhuyajie
     * @date：2020/5/18 15:43
     *  * @param null
     */
    List<Long> getRelationBookTempletByBookClassify(Long bookClassifyId);
}