package com.pcloud.book.applet.dto;

import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("小程序书单")
public class AppletBooklistDTO extends BaseDto {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("书单主题名称")
    private String booklistName;

    @ApiModelProperty("创建者名称")
    private String userName;

    @ApiModelProperty("摘要")
    private String digest;

    @ApiModelProperty("展示图")
    private String displayPic;

    @ApiModelProperty("推荐介绍类型（1编辑介绍2外部链接）")
    private Integer introduceType;

    @ApiModelProperty("推荐介绍内容")
    private String introduceContent;

    @ApiModelProperty("推荐介绍-外部链接")
    private String introduceUrl;

    @ApiModelProperty("书籍数量")
    private Integer bookCounts;

    @ApiModelProperty("分类id")
    private Long classifyId;

    @ApiModelProperty("分类名称")
    private String classifyName;

    @ApiModelProperty("图书信息")
    private List<BookDTO4Booklist> bookDTO4Booklists;
}
