package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletBookClassifyBiz;
import com.pcloud.book.applet.dto.AppletBookClassifyDTO;
import com.pcloud.book.applet.dto.AppletBookClassifyRelationDTO;
import com.pcloud.book.applet.dto.AppletUserLabelDTO;
import com.pcloud.book.applet.entity.AppletBookClassify;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.SessionUtil;

import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @ClassName com.pcloud.book.applet.facade.AppletBookClassifyFacade
 * @Author zhuyajie
 * @Description 小程序书刊分类
 * @Date 2020/5/15 16:27
 * @Version 1.0
 **/
@Api(description = "小程序书刊分类")
@RestController("appletBookClassifyFacade")
@RequestMapping("appletBookClassify")
public class AppletBookClassifyFacade {

    @Autowired
    private AppletBookClassifyBiz appletBookClassifyBiz;

    @ApiOperation("书刊分类查询")
    @GetMapping("getAppletBookClassifyList")
    public ResponseDto<List<AppletBookClassifyDTO>> getAppletBookClassifyList(@RequestParam(value = "showState", required = false) Boolean showState) {
        return new ResponseDto<>(appletBookClassifyBiz.getAppletBookClassifyList(showState));
    }

    @ApiOperation("根据id查询")
    @GetMapping("getById")
    public ResponseDto<AppletBookClassifyDTO> getById(@RequestParam("id") Long id) {
        return new ResponseDto<>(appletBookClassifyBiz.getById(id));
    }

    @ApiOperation("修改书刊分类基本信息")
    @PostMapping("updateBaseInfo")
    public ResponseDto<?> updateBaseInfo(@RequestHeader("token") String token, @RequestBody AppletBookClassify appletBookClassify) {
        SessionUtil.getToken4Redis(token);
        appletBookClassifyBiz.update(appletBookClassify);
        return new ResponseDto<>();
    }

    @ApiOperation("平台端新增客户端标签")
    @PostMapping("addUserLabel")
    public ResponseDto<?> addUserLabel(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("客户端的标签") @Validated AppletUserLabelDTO appletUserLabelDTO) {
        SessionUtil.getToken4Redis(token);
        appletBookClassifyBiz.addUserLabel(appletUserLabelDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("关联书刊一级分类")
    @PostMapping("addBookTempletRelation")
    public ResponseDto<?> addBookTempletRelation(@RequestBody List<Long> templetIdList, @RequestParam("bookClassifyId") Long bookClassifyId){
        appletBookClassifyBiz.addBookTempletRelation(templetIdList,bookClassifyId);
        return new ResponseDto<>();
    }

    @ApiOperation("根据小程序书刊分类id查书刊一级分类")
    @GetMapping("getRelationBookTempletByBookClassifyId")
    public ResponseDto<List<AppletBookClassifyRelationDTO>> getRelationBookTempletByBookClassifyId(
            @RequestHeader("token") String token, @RequestParam("bookClassifyId") @ApiParam("小程序书刊分类id") Long bookClassifyId){
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletBookClassifyBiz.getRelationBookTempletByBookClassifyId(bookClassifyId));
    }

    @ApiOperation("平台端修改客户端标签")
    @PostMapping("updateUserLabel")
    public ResponseDto<?> updateUserLabel(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("客户端的标签") @Validated AppletUserLabelDTO appletUserLabelDTO) {
        SessionUtil.getToken4Redis(token);
        appletBookClassifyBiz.updateUserLabel(appletUserLabelDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("平台端删除客户端标签")
    @GetMapping("deleteUserLabel")
    public ResponseDto<?> deleteUserLabel(
            @RequestHeader("token") String token, @RequestParam("id") Long id) {
        SessionUtil.getToken4Redis(token);
        appletBookClassifyBiz.deleteUserLabel(id);
        return new ResponseDto<>();
    }

    @ApiOperation("平台端客户端标签列表")
    @GetMapping("listUserLabel")
    public ResponseDto<List<AppletUserLabelDTO>> listUserLabel(
            @RequestHeader("token") String token, @RequestParam("appletBookClassifyId") Long appletBookClassifyId) {
        SessionUtil.getToken4Redis(token);
        List<AppletUserLabelDTO> appletUserLabelDTOS = appletBookClassifyBiz.listUserLabel(appletBookClassifyId);
        return new ResponseDto<>(appletUserLabelDTOS);
    }


    @ApiOperation("获取书刊分类列表及其标签")
    @GetMapping("getAllBookClassifyAndLabel4Wechat")
    public ResponseDto<List<AppletBookClassifyDTO>> getAllBookClassifyAndLabel4Wechat(@RequestParam(value = "grayStatus",required = false) String grayStatus){
        return new ResponseDto<>(appletBookClassifyBiz.getAllBookClassifyAndLabel(grayStatus));
    }
}
