package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.AgentStatisticsInfoDTO;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.BookGroupStatistic4AgentDTO;
import com.pcloud.book.group.dto.PersonalQrcodeDTO;
import com.pcloud.book.group.dto.QrcodeNameAndProIdDTO;
import com.pcloud.book.group.dto.TopAgentBookGroupDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.book.group.entity.QrChangeRecord;
import com.pcloud.book.group.vo.BookGroupAnalysisVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * Description 社群书群二维码数据访问层接口
 * Created by PENG on 2019/4/17.
 */
public interface BookGroupDao extends BaseDao<BookGroup> {

    /**
     * 获取DTO信息
     * @param bookGroupId 群二维码ID
     * @return
     */
    BookGroupDTO getDTOById(Long bookGroupId);

    /**
     * 获取书名和封面
     * @param bookGroupId
     * @return
     */
    BookGroupDTO getBookInfo(Long bookGroupId);

    /**
     * 批量获取DTO信息
     * @param bookGroupIds 群二维码ID列表
     * @return
     */
    List<BookGroupDTO> getDTOByIds(List<Long> bookGroupIds);

    /**
     * 获取DTO信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     *
     * @param bookIds    书刊ID
     * @param adviserIds 编辑ID
     */
    List<BookGroupDTO> getDTOByBookIdsAnsAdviserIds(List<Long> bookIds, List<Long> adviserIds);

    /**
     * 根据书刊ID删除
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    long deleteByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 根据书刊ID恢复
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    long recoverByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 关联社群码和社群书
     * @param bookGroup 社群码实体
     * @return
     */
    long linkBookGroup(BookGroup bookGroup);

    /**
     * 获取编辑社群书数量
     * @param adviserId 编辑ID
     * @return
     */
    Integer getBookGroupCount(Long adviserId);

    /**
     * @Author:lili
     * @Desr:获取群二维码名称与商品标识
     * @Date:2019/4/18 9:58
     */
    QrcodeNameAndProIdDTO getQrcodeNameAndProId(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取排序类型
     * @Date:2019/4/19 15:01
     */
    Integer getRankType(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:更新排序类型
     * @Date:2019/4/19 15:01
     */
    void updateRankType(Long bookGroupId, Integer rankType);

    /**
     * @Author:lili
     * @Desr:获取备用二维码
     * @Date:2019/5/13 15:10
     */
    String getSpareQr(Long bookGroupId);

    /**
     * 获取社群书基本信息(包括书籍封面isbn号)
     * @param bookGroupIds
     * @return
     */
    List<BookGroupDTO> getBookBaseInfoByIds(List<Long> bookGroupIds);


    /**
     * @Author:lili
     * @Desr:根据二维码获取社群码基本信息
     * @Date:2019/5/27 18:00
     */
    BookGroupDTO getBaseInfoBySceneId(Long sceneId);

    /**
     * @Author:lili
     * @Desr:是否是特殊的出版社
     * @Date:2019/5/28 11:15
     */
    Boolean isSpecialAgent(Long agentId);

    /**
    * @description 更新个人二维码
    * @author 戴兴
    * @date 2019/8/7 16:49
    */
    void updatePersonQrcode(PersonalQrcodeDTO personalQrcodeDTO);

    /**
     * 获取社群书基本信息(包括书籍封面isbn号)
     * @param paramMap
     * @return
     */
    List<BookGroupDTO> getBookInfoByIdsWithBookClockInfoId(Map<String,Object> paramMap);

    /**
     * 更新是否显示书名
     */
    void updateIsShowBookName(Boolean isShowBookName, Long partyId);

    /**
     * 获取是否显示书名
     */
    Boolean getIsShowBookName(Long partyId);

    /**
     * 删除社群书
     */
    void deleteByBookGroupId(Long bookGroupId);

    /**
     * 根据社群码id获取社群书基本信息(包括书籍封面isbn号)
     * @param bookGroupId
     * @return
     */
    BookGroupDTO getBookBaseInfoById(Long bookGroupId);

    /**
     * 编辑社群书好友人数
     * @param adviserId
     * @return
     */
    public Integer getBookGroupFriendsCountByAdviser(Long adviserId);

    /**
     * 根据社群码暗号获取社群码
     * @param bookGroupCipher
     * @return
     */
    BookGroup getByBookGroupCipher(String bookGroupCipher);

    /**
     * 根据入群方式查询社群书集合
     */
    List<BookGroup> getBookGroupByJoinGroupType(Integer joinGroupType);

    /**
     * 获取1V1的没有暗号的社群书
     */
    List<BookGroup> getNoCipherSelfBookGroups();

    /**
     * 更新暗号
     */
    void updateCipher(Long id, String bookGroupCipher);

    /**
     * 更新入群方式
     */
    void updateJoinGroupType(Long id, Integer joinGroupType);

    /**
     * 社群书分析
     * @param paramMap
     * @return
     */
    List<BookGroupAnalysisVO> listPageBookGroupAnalysis(Map<String, Object> paramMap);

    /**
     * 更新是否邀请入群
     */
    void updateIsInviteGroup(Long id, Boolean isInviteGroup);

    /**
     * 更新1v1是否有更新
     */
    void updateIsSomeUpdate(Long id, Boolean isSomeUpdate);

    /**
     * 更新上次推送时间
     */
    void updateLastPushUpdateTime(Long bookGroupId);

    /**
     * 根据类型获取社群书数量
     */
    Integer getBookGroupCountByJoinGroupType(Integer joinGroupType);

    /**
     * 查询agentId为空的数据
     */
    List<Long> getEmptyAgentIdAdviserId();

    /**
     * 更新出版社id
     */
    void updateAgentIdByAdviserId(Long adviserId, Long agentId);

    /**
     * 获取出版社创建社群书数量排行
     */
    List<TopAgentBookGroupDTO> getTopAgentCreateBookGroup(Integer joinGroupType, Integer top, List<Long> agentIds);

    /**
     * 获取所有已建分类的1v1的社群码
     */
    List<Long> get1v1HasClassifyBookGroupIds();

    /**
     * 获取出版社关联小号
     */
    List<String> getRobotWxidsByAgent(Long agentId);

    /**
     * 获取出版社个人号统计信息
     */
    List<AgentStatisticsInfoDTO> getAgentStatisticsInfo(Map<String, Object> paramMap);

    /**
     * 个人号统计数量
     */
    Integer countSelfBookGroupStatistics(Map<String,Object> map);

    /**
     * 根据类型获取社群书id集合
     */
    List<Long> getIdsByJoinGroupType(Integer joinGroupType);

    void insertQrChangeRecord(QrChangeRecord qrChangeRecord);

    Long getChangeQrChangeTarget(Long originId, String originType);

    /**
     * 获取关联社群书
     */
    List<BookGroupDTO> getAssocBookGroupByAppInfo(Map<String, Object> paramMap);

    /**
     * 更新社群码定制出版社状态
     * @param id
     * @param belongSpecialAgent
     */
    public void updateSpecialState(Long id, Boolean belongSpecialAgent);

    /**
     * 根据书刊id获取社群书基本信息
     * @param bookId
     * @return
     */
    BookGroupStatistic4AgentDTO getBaseInfoByBookId(Long bookId);

    /**
     * 根据书籍简称获取
     */
    BookGroup getByShortBookName(String shortBookName);

    List<BookGroup> listOldLabel();

    void updateSubjectByProLabel(Long proLebelId, Long subjectId);
    void updateGradeByDepLabel(Long depLabelId, Long graLabelId);

    Long getOldDataMax();

    void insertOldData(Long id);

    public Long getBookGroupId4OldData(Long raysBookId);

    Long getIdByBookNameAndJoinGroupType(String bookName, Integer joinGroupType);

    Integer getJoinGroupType(Map<String,Object> map);
}
